/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.RegionImpl;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemoryRegionImpl
implements RegionImpl {
    private static final String DEFAULT_DOMAIN = "amazonaws.com";
    private final String name;
    private final String domain;
    private final Map<String, String> endpoints = new HashMap<String, String>();
    private final List<String> https = new ArrayList<String>();
    private final List<String> http = new ArrayList<String>();

    public InMemoryRegionImpl(String string, String string2) {
        ValidationUtils.assertNotNull(string, "region name");
        this.name = string;
        this.domain = string2 == null ? DEFAULT_DOMAIN : string2;
    }

    public InMemoryRegionImpl addEndpoint(String string, String string2) {
        ValidationUtils.assertNotNull(string, "service name");
        ValidationUtils.assertNotNull(string2, "endpoint");
        this.endpoints.put(string, string2);
        return this;
    }

    public InMemoryRegionImpl addHttps(String string) {
        this.https.add(string);
        return this;
    }

    public InMemoryRegionImpl addHttp(String string) {
        this.http.add(string);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getPartition() {
        throw new UnsupportedOperationException("Partition is not available in the in memory implementation");
    }

    @Override
    public boolean isServiceSupported(String string) {
        return this.endpoints.containsKey(string);
    }

    @Override
    public String getServiceEndpoint(String string) {
        return this.endpoints.get(string);
    }

    @Override
    public boolean hasHttpsEndpoint(String string) {
        return this.https.contains(string);
    }

    @Override
    public boolean hasHttpEndpoint(String string) {
        return this.http.contains(string);
    }

    @Override
    public Collection<String> getAvailableEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }
}

