/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadata;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.util.AwsHostNameUtils;
import java.net.URI;

@SdkProtectedApi
public class EndpointToRegion {
    public static String guessRegionNameForEndpoint(String string) {
        return EndpointToRegion.guessRegionNameForEndpoint(string, null);
    }

    public static String guessRegionNameForEndpoint(String string, String string2) {
        return EndpointToRegion.guessRegionOrRegionNameForEndpoint(string, string2).getRegionName();
    }

    public static String guessRegionNameForEndpointWithDefault(String string, String string2, String string3) {
        String string4 = EndpointToRegion.guessRegionNameForEndpoint(string, string2);
        return string4 != null ? string4 : string3;
    }

    public static Region guessRegionForEndpoint(String string) {
        return EndpointToRegion.guessRegionForEndpoint(string, null);
    }

    public static Region guessRegionForEndpoint(String string, String string2) {
        return EndpointToRegion.guessRegionOrRegionNameForEndpoint(string, string2).getRegion();
    }

    private static RegionOrRegionName guessRegionOrRegionNameForEndpoint(String string, String string2) {
        if (string == null) {
            return new RegionOrRegionName();
        }
        String string3 = null;
        try {
            string3 = URI.create(string).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            string3 = URI.create("http://" + string).getHost();
        }
        if (string3 == null) {
            return new RegionOrRegionName();
        }
        String string4 = AwsHostNameUtils.parseRegionFromInternalConfig(string3);
        if (string4 != null) {
            return new RegionOrRegionName(string4);
        }
        String string5 = AwsHostNameUtils.parseRegionFromAwsPartitionPattern(string3);
        if (string5 != null) {
            return new RegionOrRegionName(string5);
        }
        String string6 = AwsHostNameUtils.parseRegionUsingServiceHint(string3, string2);
        if (string6 != null) {
            return new RegionOrRegionName(string6);
        }
        RegionMetadata regionMetadata = RegionUtils.getRegionMetadata();
        Region region = regionMetadata.tryGetRegionByExplicitEndpoint(string3);
        if (region != null) {
            return new RegionOrRegionName(region);
        }
        Region region2 = regionMetadata.tryGetRegionByEndpointDnsSuffix(string3);
        if (region2 != null) {
            return new RegionOrRegionName(region2);
        }
        String string7 = AwsHostNameUtils.parseRegionFromAfterServiceName(string3, string2);
        if (string7 != null) {
            return new RegionOrRegionName(string7);
        }
        return new RegionOrRegionName();
    }

    private static class RegionOrRegionName {
        private final Region region;
        private final String regionName;

        private RegionOrRegionName(Region region) {
            this.region = region;
            this.regionName = null;
        }

        private RegionOrRegionName(String string) {
            this.region = null;
            this.regionName = string;
        }

        private RegionOrRegionName() {
            this.region = null;
            this.regionName = null;
        }

        public Region getRegion() {
            if (this.regionName != null) {
                return RegionUtils.getRegion(this.regionName);
            }
            return this.region;
        }

        public String getRegionName() {
            if (this.region != null) {
                return this.region.getName();
            }
            return this.regionName;
        }
    }
}

