/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.TimestampFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.Timestamp;
import software.amazon.ion.system.IonWriterBuilder;

@SdkInternalApi
abstract class SdkIonGenerator
implements StructuredJsonGenerator {
    private final String contentType;
    protected final IonWriter writer;

    private SdkIonGenerator(IonWriter ionWriter, String string) {
        this.writer = ionWriter;
        this.contentType = string;
    }

    @Override
    public StructuredJsonGenerator writeStartArray() {
        try {
            this.writer.stepIn(IonType.LIST);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeNull() {
        try {
            this.writer.writeNull();
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndArray() {
        try {
            this.writer.stepOut();
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeStartObject() {
        try {
            this.writer.stepIn(IonType.STRUCT);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndObject() {
        try {
            this.writer.stepOut();
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeFieldName(String string) {
        this.writer.setFieldName(string);
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(String string) {
        try {
            this.writer.writeString(string);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(boolean bl) {
        try {
            this.writer.writeBool(bl);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(long l) {
        try {
            this.writer.writeInt(l);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(double d) {
        try {
            this.writer.writeFloat(d);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(float f) {
        try {
            this.writer.writeFloat(f);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(short s2) {
        try {
            this.writer.writeInt(s2);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(int n) {
        try {
            this.writer.writeInt(n);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(ByteBuffer byteBuffer) {
        try {
            this.writer.writeBlob(BinaryUtils.copyAllBytesFrom(byteBuffer));
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(Date date, TimestampFormat timestampFormat) {
        try {
            this.writer.writeTimestamp(Timestamp.forDateZ(date));
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigDecimal bigDecimal) {
        try {
            this.writer.writeDecimal(bigDecimal);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigInteger bigInteger) {
        try {
            this.writer.writeInt(bigInteger);
        }
        catch (IOException iOException) {
            throw new SdkClientException(iOException);
        }
        return this;
    }

    @Override
    public abstract byte[] getBytes();

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public static SdkIonGenerator create(IonWriterBuilder ionWriterBuilder, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IonWriter ionWriter = ionWriterBuilder.build(byteArrayOutputStream);
        return new ByteArraySdkIonGenerator(byteArrayOutputStream, ionWriter, string);
    }

    private static class ByteArraySdkIonGenerator
    extends SdkIonGenerator {
        private final ByteArrayOutputStream bytes;

        public ByteArraySdkIonGenerator(ByteArrayOutputStream byteArrayOutputStream, IonWriter ionWriter, String string) {
            super(ionWriter, string);
            this.bytes = byteArrayOutputStream;
        }

        @Override
        public byte[] getBytes() {
            try {
                this.writer.finish();
            }
            catch (IOException iOException) {
                throw new SdkClientException(iOException);
            }
            return this.bytes.toByteArray();
        }
    }
}

