/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@NotThreadSafe
@SdkProtectedApi
public class JsonClientMetadata {
    private final List<JsonErrorShapeMetadata> errorsMetadata = new ArrayList<JsonErrorShapeMetadata>();
    private String protocolVersion;
    private String contentTypeOverride;
    private boolean supportsCbor;
    private boolean supportsIon;
    private Class<? extends RuntimeException> baseServiceExceptionClass = AmazonServiceException.class;

    public JsonClientMetadata addErrorMetadata(JsonErrorShapeMetadata jsonErrorShapeMetadata) {
        this.errorsMetadata.add(jsonErrorShapeMetadata);
        return this;
    }

    public JsonClientMetadata addAllErrorMetadata(JsonErrorShapeMetadata ... jsonErrorShapeMetadataArray) {
        Collections.addAll(this.errorsMetadata, jsonErrorShapeMetadataArray);
        return this;
    }

    public List<JsonErrorShapeMetadata> getErrorShapeMetadata() {
        return this.errorsMetadata;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public JsonClientMetadata withProtocolVersion(String string) {
        this.protocolVersion = string;
        return this;
    }

    public String getContentTypeOverride() {
        return this.contentTypeOverride;
    }

    public JsonClientMetadata withContentTypeOverride(String string) {
        this.contentTypeOverride = string;
        return this;
    }

    public boolean isSupportsCbor() {
        return this.supportsCbor;
    }

    public JsonClientMetadata withSupportsCbor(boolean bl) {
        this.supportsCbor = bl;
        return this;
    }

    public Class<? extends RuntimeException> getBaseServiceExceptionClass() {
        return this.baseServiceExceptionClass;
    }

    public boolean isSupportsIon() {
        return this.supportsIon;
    }

    public JsonClientMetadata withSupportsIon(boolean bl) {
        this.supportsIon = bl;
        return this;
    }

    public JsonClientMetadata withBaseServiceExceptionClass(Class<? extends RuntimeException> clazz) {
        this.baseServiceExceptionClass = clazz;
        return this;
    }
}

