/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.monitoring.MonitoringEvent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class AsynchronousAgentDispatcher {
    private static final Log LOG = LogFactory.getLog(AsynchronousAgentDispatcher.class);
    private static final int QUEUE_SIZE = 4096;
    private static AsynchronousAgentDispatcher instance;
    private final ObjectWriter writer;
    private int refCount = 0;
    private volatile BlockingQueue<WriteTask> tasks;
    private ExecutorService exec;
    private volatile boolean initialized = false;

    private AsynchronousAgentDispatcher() {
        ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        }
        catch (LinkageError linkageError) {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
        }
        this.writer = objectMapper.writer();
    }

    @SdkTestInternalApi
    AsynchronousAgentDispatcher(ObjectWriter objectWriter) {
        this.writer = objectWriter;
    }

    public void addWriteTask(MonitoringEvent monitoringEvent, DatagramChannel datagramChannel, int n) {
        if (!this.initialized) {
            throw new IllegalStateException("Dispatcher is not initialized!");
        }
        this.tasks.add(new WriteTask(monitoringEvent, datagramChannel, n));
    }

    public synchronized void init() {
        if (!this.initialized) {
            this.tasks = new LinkedBlockingQueue<WriteTask>(4096);
            this.exec = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable2) {
                    Thread thread2 = new Thread(runnable2);
                    thread2.setName("CsmAgentAsyncDispatchThread");
                    thread2.setDaemon(true);
                    return thread2;
                }
            });
            this.exec.submit(new WriterRunnable());
            this.initialized = true;
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount > 0) {
            --this.refCount;
        }
        if (this.refCount == 0 && this.initialized) {
            this.exec.shutdown();
            this.tasks.clear();
            this.exec = null;
            this.tasks = null;
            this.initialized = false;
        }
    }

    public static synchronized AsynchronousAgentDispatcher getInstance() {
        if (instance == null) {
            instance = new AsynchronousAgentDispatcher();
        }
        return instance;
    }

    private byte[] serialize(MonitoringEvent monitoringEvent) throws IOException {
        return this.writer.writeValueAsBytes(monitoringEvent);
    }

    private static class WriteTask {
        private final MonitoringEvent event;
        private final DatagramChannel channel;
        private final int maxSize;

        public WriteTask(MonitoringEvent monitoringEvent, DatagramChannel datagramChannel, int n) {
            this.event = monitoringEvent;
            this.channel = datagramChannel;
            this.maxSize = n;
        }
    }

    private class WriterRunnable
    implements Runnable {
        private WriterRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WriteTask writeTask;
                        byte[] byArray;
                        if ((byArray = AsynchronousAgentDispatcher.this.serialize((writeTask = (WriteTask)AsynchronousAgentDispatcher.this.tasks.take()).event)).length > writeTask.maxSize) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Event exceeds the send maximum event size of " + writeTask.maxSize + ". Dropping event.");
                            continue;
                        }
                        writeTask.channel.write(ByteBuffer.wrap(byArray));
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    LOG.debug("Writer thread interrupted", interruptedException);
                }
                catch (Exception exception) {
                    LOG.debug("Exception thrown while attempting to send event to agent", exception);
                    continue;
                }
                break;
            }
        }
    }
}

