/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.monitoring.CsmConfiguration;
import com.amazonaws.monitoring.CsmConfigurationProvider;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;

@ThreadSafe
public final class ProfileCsmConfigurationProvider
implements CsmConfigurationProvider {
    public static final String CSM_ENABLED_PROPERTY = "csm_enabled";
    public static final String CSM_HOST_PROPERTY = "csm_host";
    public static final String CSM_PORT_PROPERTY = "csm_port";
    public static final String CSM_CLIENT_ID_PROPERTY = "csm_client_id";
    private final AwsProfileFileLocationProvider configFileLocationProvider;
    private volatile String profileName;
    private volatile ProfilesConfigFile configFile;

    public ProfileCsmConfigurationProvider() {
        this(null, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER);
    }

    public ProfileCsmConfigurationProvider(String string) {
        this(string, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER);
    }

    public ProfileCsmConfigurationProvider(String string, AwsProfileFileLocationProvider awsProfileFileLocationProvider) {
        this.profileName = string;
        this.configFileLocationProvider = awsProfileFileLocationProvider;
    }

    @Override
    public CsmConfiguration getConfiguration() {
        String string = this.getProfileName();
        BasicProfile basicProfile = this.getProfile(string);
        if (basicProfile == null) {
            throw new SdkClientException(String.format("Could not find the '%s' profile!", string));
        }
        String string2 = basicProfile.getPropertyValue(CSM_ENABLED_PROPERTY);
        if (string2 == null) {
            throw new SdkClientException(String.format("The '%s' profile does not define all the required properties!", string));
        }
        String string3 = basicProfile.getPropertyValue(CSM_HOST_PROPERTY);
        string3 = string3 == null ? "127.0.0.1" : string3;
        String string4 = basicProfile.getPropertyValue(CSM_PORT_PROPERTY);
        String string5 = basicProfile.getPropertyValue(CSM_CLIENT_ID_PROPERTY);
        string5 = string5 == null ? "" : string5;
        try {
            int n = string4 == null ? 31000 : Integer.parseInt(string4);
            return CsmConfiguration.builder().withEnabled(Boolean.parseBoolean(string2)).withHost(string3).withPort(n).withClientId(string5).build();
        }
        catch (Exception exception) {
            throw new SdkClientException(String.format("Unable to load configuration from the '%s' profile!", string), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProfileName() {
        if (this.profileName == null) {
            ProfileCsmConfigurationProvider profileCsmConfigurationProvider = this;
            synchronized (profileCsmConfigurationProvider) {
                if (this.profileName == null) {
                    this.profileName = AwsProfileNameLoader.INSTANCE.loadProfileName();
                }
            }
        }
        return this.profileName;
    }

    private synchronized BasicProfile getProfile(String string) {
        return this.getProfilesConfigFile().getBasicProfile(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilesConfigFile getProfilesConfigFile() {
        if (this.configFile == null) {
            ProfileCsmConfigurationProvider profileCsmConfigurationProvider = this;
            synchronized (profileCsmConfigurationProvider) {
                if (this.configFile == null) {
                    try {
                        this.configFile = new ProfilesConfigFile(this.configFileLocationProvider.getLocation());
                    }
                    catch (Exception exception) {
                        throw new SdkClientException("Unable to load config file", exception);
                    }
                }
            }
        }
        return this.configFile;
    }
}

