/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring;

import com.amazonaws.SdkClientException;
import com.amazonaws.monitoring.CsmConfiguration;
import com.amazonaws.monitoring.CsmConfigurationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CsmConfigurationProviderChain
implements CsmConfigurationProvider {
    private static final Log log = LogFactory.getLog(CsmConfigurationProviderChain.class);
    private final List<CsmConfigurationProvider> providers = new ArrayList<CsmConfigurationProvider>();

    public CsmConfigurationProviderChain(CsmConfigurationProvider ... csmConfigurationProviderArray) {
        if (csmConfigurationProviderArray != null) {
            Collections.addAll(this.providers, csmConfigurationProviderArray);
        }
    }

    @Override
    public CsmConfiguration getConfiguration() {
        for (CsmConfigurationProvider csmConfigurationProvider : this.providers) {
            try {
                return csmConfigurationProvider.getConfiguration();
            }
            catch (SdkClientException sdkClientException) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Unable to load configuration from " + csmConfigurationProvider.toString() + ": " + sdkClientException.getMessage());
            }
        }
        throw new SdkClientException("Could not resolve client side monitoring configuration from the configured providers in the chain");
    }
}

