/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.monitoring;

public final class CsmConfiguration {
    private final boolean enabled;
    private final String host;
    private final int port;
    private final String clientId;

    public CsmConfiguration(boolean bl, int n, String string) {
        this.enabled = bl;
        this.host = null;
        this.port = n;
        this.clientId = string;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CsmConfiguration(Builder builder) {
        this.enabled = builder.enabled == null ? false : builder.enabled;
        this.host = builder.host == null ? "127.0.0.1" : builder.host;
        this.port = builder.port == null ? 31000 : builder.port;
        this.clientId = builder.clientId == null ? "" : builder.clientId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CsmConfiguration csmConfiguration = (CsmConfiguration)object;
        if (this.enabled != csmConfiguration.enabled) {
            return false;
        }
        if (this.port != csmConfiguration.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(csmConfiguration.host) : csmConfiguration.host != null) {
            return false;
        }
        return this.clientId != null ? this.clientId.equals(csmConfiguration.clientId) : csmConfiguration.clientId == null;
    }

    public int hashCode() {
        int n = this.enabled ? 1 : 0;
        n = 31 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 31 * n + this.port;
        n = 31 * n + (this.clientId != null ? this.clientId.hashCode() : 0);
        return n;
    }

    public static class Builder {
        private Boolean enabled;
        private String host;
        private Integer port;
        private String clientId;

        private Builder() {
        }

        public Builder withEnabled(Boolean bl) {
            this.enabled = bl;
            return this;
        }

        public Builder withClientId(String string) {
            this.clientId = string;
            return this;
        }

        public Builder withHost(String string) {
            this.host = string;
            return this;
        }

        public Builder withPort(Integer n) {
            this.port = n;
            return this;
        }

        public CsmConfiguration build() {
            return new CsmConfiguration(this);
        }
    }
}

