/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jmespath;

import com.amazonaws.jmespath.CamelCaseUtils;
import com.amazonaws.jmespath.Comparator;
import com.amazonaws.jmespath.InvalidTypeException;
import com.amazonaws.jmespath.JmesPathAndExpression;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFilter;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathFunction;
import com.amazonaws.jmespath.JmesPathIdentity;
import com.amazonaws.jmespath.JmesPathLiteral;
import com.amazonaws.jmespath.JmesPathMultiSelectList;
import com.amazonaws.jmespath.JmesPathNotExpression;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.JmesPathValueProjection;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JmesPathEvaluationVisitor
implements JmesPathVisitor<JsonNode, JsonNode> {
    @Override
    public JsonNode visit(JmesPathSubExpression jmesPathSubExpression, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathSubExpression.getExpressions().get(0).accept(this, jsonNode);
        for (int i = 1; i < jmesPathSubExpression.getExpressions().size(); ++i) {
            jsonNode2 = jmesPathSubExpression.getExpressions().get(i).accept(this, jsonNode2);
        }
        return jsonNode2;
    }

    @Override
    public JsonNode visit(JmesPathField jmesPathField, JsonNode jsonNode) {
        if (jsonNode.isObject()) {
            return jsonNode.get(CamelCaseUtils.toCamelCase(jmesPathField.getValue()));
        }
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visit(JmesPathProjection jmesPathProjection, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathProjection.getLhsExpr().accept(this, jsonNode);
        if (jsonNode2.isArray()) {
            Iterator<JsonNode> iterator2 = jsonNode2.elements();
            ArrayNode arrayNode = ObjectMapperSingleton.getObjectMapper().createArrayNode();
            while (iterator2.hasNext()) {
                JsonNode jsonNode3 = jmesPathProjection.getProjectionExpr().accept(this, iterator2.next());
                if (jsonNode3 == null) continue;
                arrayNode.add(jsonNode3);
            }
            return arrayNode;
        }
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visit(JmesPathFlatten jmesPathFlatten, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathFlatten.getFlattenExpr().accept(this, jsonNode);
        if (jsonNode2.isArray()) {
            Iterator<JsonNode> iterator2 = jsonNode2.elements();
            ArrayNode arrayNode = ObjectMapperSingleton.getObjectMapper().createArrayNode();
            while (iterator2.hasNext()) {
                JsonNode jsonNode3 = iterator2.next();
                if (jsonNode3 == null) continue;
                if (jsonNode3.isArray()) {
                    for (JsonNode jsonNode4 : jsonNode3) {
                        if (jsonNode4 == null) continue;
                        arrayNode.add(jsonNode4);
                    }
                    continue;
                }
                arrayNode.add(jsonNode3);
            }
            return arrayNode;
        }
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visit(JmesPathIdentity jmesPathIdentity, JsonNode jsonNode) {
        return jsonNode;
    }

    @Override
    public JsonNode visit(JmesPathValueProjection jmesPathValueProjection, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathValueProjection.getLhsExpr().accept(this, jsonNode);
        if (jsonNode2.isObject()) {
            ArrayNode arrayNode = ObjectMapperSingleton.getObjectMapper().createArrayNode();
            Iterator<JsonNode> iterator2 = jsonNode2.elements();
            while (iterator2.hasNext()) {
                JsonNode jsonNode3 = jmesPathValueProjection.getRhsExpr().accept(this, iterator2.next());
                if (jsonNode3 == null) continue;
                arrayNode.add(jsonNode3);
            }
            return arrayNode;
        }
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visit(JmesPathFunction jmesPathFunction, JsonNode jsonNode) throws InvalidTypeException {
        ArrayList<JsonNode> arrayList = new ArrayList<JsonNode>();
        List<JmesPathExpression> list = jmesPathFunction.getExpressions();
        for (JmesPathExpression jmesPathExpression : list) {
            arrayList.add(jmesPathExpression.accept(this, jsonNode));
        }
        return jmesPathFunction.evaluate(arrayList);
    }

    @Override
    public JsonNode visit(JmesPathLiteral jmesPathLiteral, JsonNode jsonNode) {
        return jmesPathLiteral.getValue();
    }

    @Override
    public JsonNode visit(JmesPathFilter jmesPathFilter, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathFilter.getLhsExpr().accept(this, jsonNode);
        if (jsonNode2.isArray()) {
            Iterator<JsonNode> iterator2 = jsonNode2.elements();
            ArrayNode arrayNode = ObjectMapperSingleton.getObjectMapper().createArrayNode();
            while (iterator2.hasNext()) {
                JsonNode jsonNode3;
                JsonNode jsonNode4 = iterator2.next();
                if (!jmesPathFilter.getComparator().accept(this, jsonNode4).equals(BooleanNode.TRUE) || (jsonNode3 = jmesPathFilter.getRhsExpr().accept(this, jsonNode4)) == null) continue;
                arrayNode.add(jsonNode3);
            }
            return arrayNode;
        }
        return NullNode.getInstance();
    }

    @Override
    public JsonNode visit(Comparator comparator, JsonNode jsonNode) {
        JsonNode jsonNode2;
        JsonNode jsonNode3 = comparator.getLhsExpr().accept(this, jsonNode);
        if (comparator.matches(jsonNode3, jsonNode2 = comparator.getRhsExpr().accept(this, jsonNode))) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    @Override
    public JsonNode visit(JmesPathNotExpression jmesPathNotExpression, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathNotExpression.getExpr().accept(this, jsonNode);
        if (jsonNode2 != BooleanNode.TRUE) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    @Override
    public JsonNode visit(JmesPathAndExpression jmesPathAndExpression, JsonNode jsonNode) throws InvalidTypeException {
        JsonNode jsonNode2 = jmesPathAndExpression.getLhsExpr().accept(this, jsonNode);
        JsonNode jsonNode3 = jmesPathAndExpression.getRhsExpr().accept(this, jsonNode);
        if (jsonNode2 == BooleanNode.TRUE) {
            return jsonNode3;
        }
        return jsonNode2;
    }

    @Override
    public JsonNode visit(JmesPathMultiSelectList jmesPathMultiSelectList, JsonNode jsonNode) throws InvalidTypeException {
        List<JmesPathExpression> list = jmesPathMultiSelectList.getExpressions();
        ArrayNode arrayNode = ObjectMapperSingleton.getObjectMapper().createArrayNode();
        for (JmesPathExpression jmesPathExpression : list) {
            arrayNode.add(jmesPathExpression.accept(this, jsonNode));
        }
        return arrayNode;
    }
}

