/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.http;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.protocol.json.JsonContent;
import com.amazonaws.util.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;

@SdkInternalApi
public class IonErrorCodeParser
implements ErrorCodeParser {
    private static final Log log = LogFactory.getLog(IonErrorCodeParser.class);
    private static final String TYPE_PREFIX = "aws-type:";
    private static final String X_AMZN_REQUEST_ID_HEADER = "x-amzn-RequestId";
    private final IonSystem ionSystem;

    public IonErrorCodeParser(IonSystem ionSystem) {
        this.ionSystem = ionSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String parseErrorCode(HttpResponse httpResponse, JsonContent jsonContent) {
        IonReader ionReader = this.ionSystem.newReader(jsonContent.getRawContent());
        try {
            String[] stringArray;
            IonType ionType = ionReader.next();
            if (ionType != IonType.STRUCT) {
                throw new SdkClientException(String.format("Can only get error codes from structs (saw %s), request id %s", new Object[]{ionType, IonErrorCodeParser.getRequestId(httpResponse)}));
            }
            boolean bl = false;
            String string = null;
            for (String string2 : stringArray = ionReader.getTypeAnnotations()) {
                if (!string2.startsWith(TYPE_PREFIX)) continue;
                if (bl) {
                    throw new SdkClientException(String.format("Multiple error code annotations found for request id %s", IonErrorCodeParser.getRequestId(httpResponse)));
                }
                bl = true;
                string = string2.substring(TYPE_PREFIX.length());
            }
            String[] stringArray2 = string;
            return stringArray2;
        }
        finally {
            IOUtils.closeQuietly(ionReader, log);
        }
    }

    private static String getRequestId(HttpResponse httpResponse) {
        return httpResponse.getHeaders().get(X_AMZN_REQUEST_ID_HEADER);
    }
}

