/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.http;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.protocol.json.JsonContent;
import java.util.Arrays;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    public CompositeErrorCodeParser(Iterable<ErrorCodeParser> iterable) {
        this.parsers = iterable;
    }

    public CompositeErrorCodeParser(ErrorCodeParser ... errorCodeParserArray) {
        this.parsers = Arrays.asList(errorCodeParserArray);
    }

    @Override
    public String parseErrorCode(HttpResponse httpResponse, JsonContent jsonContent) {
        for (ErrorCodeParser errorCodeParser : this.parsers) {
            String string = errorCodeParser.parseErrorCode(httpResponse, jsonContent);
            if (string == null) continue;
            return string;
        }
        return null;
    }
}

