/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.internal.config.Builder;
import com.amazonaws.internal.config.EndpointDiscoveryConfig;
import com.amazonaws.internal.config.HostRegexToRegionMapping;
import com.amazonaws.internal.config.HttpClientConfig;
import com.amazonaws.internal.config.InternalConfigJsonHelper;
import com.amazonaws.internal.config.JsonIndex;
import com.amazonaws.internal.config.SignerConfig;
import com.amazonaws.internal.config.SignerConfigJsonHelper;
import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.ClassLoaderHelper;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Immutable
public class InternalConfig {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private static final InternalLogApi log = InternalLogFactory.getLog(InternalConfig.class);
    static final String DEFAULT_CONFIG_RESOURCE_RELATIVE_PATH = "awssdk_config_default.json";
    static final String DEFAULT_CONFIG_RESOURCE_ABSOLUTE_PATH = "/com/amazonaws/internal/config/awssdk_config_default.json";
    static final String CONFIG_OVERRIDE_RESOURCE = "awssdk_config_override.json";
    static final String ENDPOINT_DISCOVERY_CONFIG_ABSOLUTE_PATH = "/com/amazonaws/endpointdiscovery/endpoint-discovery.json";
    private static final String SERVICE_REGION_DELIMITOR = "/";
    private final SignerConfig defaultSignerConfig;
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners;
    private final Map<String, SignerConfig> serviceSigners;
    private final Map<String, HttpClientConfig> httpClients;
    private final List<HostRegexToRegionMapping> hostRegexToRegionMappings;
    private final String userAgentTemplate;
    private final boolean endpointDiscoveryEnabled;
    private final String defaultRetryMode;
    private URL defaultConfigFileLocation;
    private URL overrideConfigFileLocation;

    InternalConfig(InternalConfigJsonHelper internalConfigJsonHelper, InternalConfigJsonHelper internalConfigJsonHelper2, EndpointDiscoveryConfig endpointDiscoveryConfig) {
        SignerConfigJsonHelper signerConfigJsonHelper = internalConfigJsonHelper.getDefaultSigner();
        this.defaultSignerConfig = signerConfigJsonHelper == null ? null : signerConfigJsonHelper.build();
        this.regionSigners = this.mergeSignerMap(internalConfigJsonHelper.getRegionSigners(), internalConfigJsonHelper2.getRegionSigners(), "region");
        this.serviceSigners = this.mergeSignerMap(internalConfigJsonHelper.getServiceSigners(), internalConfigJsonHelper2.getServiceSigners(), "service");
        this.serviceRegionSigners = this.mergeSignerMap(internalConfigJsonHelper.getServiceRegionSigners(), internalConfigJsonHelper2.getServiceRegionSigners(), "service/region");
        this.httpClients = this.merge(internalConfigJsonHelper.getHttpClients(), internalConfigJsonHelper2.getHttpClients());
        this.hostRegexToRegionMappings = this.append(internalConfigJsonHelper2.getHostRegexToRegionMappings(), internalConfigJsonHelper.getHostRegexToRegionMappings());
        this.userAgentTemplate = internalConfigJsonHelper2.getUserAgentTemplate() != null ? internalConfigJsonHelper2.getUserAgentTemplate() : internalConfigJsonHelper.getUserAgentTemplate();
        this.endpointDiscoveryEnabled = endpointDiscoveryConfig.isEndpointDiscoveryEnabled();
        this.defaultRetryMode = internalConfigJsonHelper2.getDefaultRetryMode();
    }

    private Map<String, SignerConfig> mergeSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] jsonIndexArray, JsonIndex<SignerConfigJsonHelper, SignerConfig>[] jsonIndexArray2, String string) {
        Map<String, SignerConfig> map = this.buildSignerMap(jsonIndexArray, string);
        Map<String, SignerConfig> map2 = this.buildSignerMap(jsonIndexArray2, string);
        map.putAll(map2);
        return Collections.unmodifiableMap(map);
    }

    private <C extends Builder<T>, T> Map<String, T> merge(JsonIndex<C, T>[] jsonIndexArray, JsonIndex<C, T>[] jsonIndexArray2) {
        Map<String, T> map = this.buildMap(jsonIndexArray);
        Map<String, T> map2 = this.buildMap(jsonIndexArray2);
        map.putAll(map2);
        return Collections.unmodifiableMap(map);
    }

    private <C extends Builder<T>, T> Map<String, T> buildMap(JsonIndex<C, T>[] jsonIndexArray) {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        if (jsonIndexArray != null) {
            for (JsonIndex<C, T> jsonIndex : jsonIndexArray) {
                String string = jsonIndex.getKey();
                T t2 = hashMap.put(string, jsonIndex.newReadOnlyConfig());
                if (t2 == null) continue;
                log.warn("Duplicate definition of signer for " + jsonIndex.getKey());
            }
        }
        return hashMap;
    }

    private <C extends Builder<T>, T> List<T> append(C[] CArray, C[] CArray2) {
        LinkedList<T> linkedList = new LinkedList<T>();
        if (CArray != null) {
            for (C c : CArray) {
                linkedList.add(c.build());
            }
        }
        if (CArray2 != null) {
            for (C c : CArray2) {
                linkedList.add(c.build());
            }
        }
        return linkedList;
    }

    private Map<String, SignerConfig> buildSignerMap(JsonIndex<SignerConfigJsonHelper, SignerConfig>[] jsonIndexArray, String string) {
        HashMap<String, SignerConfig> hashMap = new HashMap<String, SignerConfig>();
        if (jsonIndexArray != null) {
            for (JsonIndex<SignerConfigJsonHelper, SignerConfig> jsonIndex : jsonIndexArray) {
                String string2 = jsonIndex.getKey();
                SignerConfig signerConfig = hashMap.put(string2, jsonIndex.newReadOnlyConfig());
                if (signerConfig == null) continue;
                log.warn("Duplicate definition of signer for " + string + " " + jsonIndex.getKey());
            }
        }
        return hashMap;
    }

    public SignerConfig getSignerConfig(String string) {
        return this.getSignerConfig(string, null);
    }

    public HttpClientConfig getHttpClientConfig(String string) {
        return this.httpClients.get(string);
    }

    public SignerConfig getSignerConfig(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (string2 != null) {
            String string3 = string + SERVICE_REGION_DELIMITOR + string2;
            signerConfig = this.serviceRegionSigners.get(string3);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(string2);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(string)) == null ? this.defaultSignerConfig : signerConfig;
    }

    public List<HostRegexToRegionMapping> getHostRegexToRegionMappings() {
        return Collections.unmodifiableList(this.hostRegexToRegionMappings);
    }

    public String getUserAgentTemplate() {
        return this.userAgentTemplate;
    }

    public boolean endpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public String getDefaultRetryMode() {
        return this.defaultRetryMode;
    }

    static <T> T loadfrom(URL uRL, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        T t2 = MAPPER.readValue(uRL, clazz);
        return t2;
    }

    static InternalConfig load() throws JsonParseException, JsonMappingException, IOException {
        InternalConfigJsonHelper internalConfigJsonHelper;
        URL uRL = InternalConfig.getResource(DEFAULT_CONFIG_RESOURCE_RELATIVE_PATH, true, false);
        if (uRL == null) {
            uRL = InternalConfig.getResource(DEFAULT_CONFIG_RESOURCE_ABSOLUTE_PATH, false, false);
        }
        InternalConfigJsonHelper internalConfigJsonHelper2 = InternalConfig.loadfrom(uRL, InternalConfigJsonHelper.class);
        URL uRL2 = InternalConfig.getResource(CONFIG_OVERRIDE_RESOURCE, false, true);
        if (uRL2 == null) {
            uRL2 = InternalConfig.getResource(CONFIG_OVERRIDE_RESOURCE, false, false);
        }
        if (uRL2 == null) {
            log.debug("Configuration override awssdk_config_override.json not found.");
            internalConfigJsonHelper = new InternalConfigJsonHelper();
        } else {
            internalConfigJsonHelper = InternalConfig.loadfrom(uRL2, InternalConfigJsonHelper.class);
        }
        EndpointDiscoveryConfig endpointDiscoveryConfig = new EndpointDiscoveryConfig();
        URL uRL3 = InternalConfig.getResource(ENDPOINT_DISCOVERY_CONFIG_ABSOLUTE_PATH, false, false);
        if (uRL3 != null) {
            endpointDiscoveryConfig = InternalConfig.loadfrom(uRL3, EndpointDiscoveryConfig.class);
        }
        InternalConfig internalConfig = new InternalConfig(internalConfigJsonHelper2, internalConfigJsonHelper, endpointDiscoveryConfig);
        internalConfig.setDefaultConfigFileLocation(uRL);
        internalConfig.setOverrideConfigFileLocation(uRL2);
        return internalConfig;
    }

    private static URL getResource(String string, boolean bl, boolean bl2) {
        string = bl2 ? SERVICE_REGION_DELIMITOR + string : string;
        URL uRL = ClassLoaderHelper.getResource(string, bl, InternalConfig.class);
        return uRL;
    }

    public URL getDefaultConfigFileLocation() {
        return this.defaultConfigFileLocation;
    }

    public URL getOverrideConfigFileLocation() {
        return this.overrideConfigFileLocation;
    }

    void setDefaultConfigFileLocation(URL uRL) {
        this.defaultConfigFileLocation = uRL;
    }

    void setOverrideConfigFileLocation(URL uRL) {
        this.overrideConfigFileLocation = uRL;
    }

    void dump() {
        StringBuilder stringBuilder = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners).append("\n").append("userAgentTemplate: ").append(this.userAgentTemplate);
        log.debug(stringBuilder.toString());
    }

    public static class Factory {
        private static final InternalConfig SINGELTON;

        public static InternalConfig getInternalConfig() {
            return SINGELTON;
        }

        static {
            InternalConfig internalConfig = null;
            try {
                internalConfig = InternalConfig.load();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Fatal: Failed to load the internal config for AWS Java SDK", exception);
            }
            SINGELTON = internalConfig;
        }
    }
}

