/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.annotation.Immutable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@Immutable
public class HostRegexToRegionMapping {
    private final String regionName;
    private final Pattern hostNameRegexPattern;

    public HostRegexToRegionMapping(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid HostRegexToRegionMapping configuration: hostNameRegex must be non-empty");
        }
        try {
            this.hostNameRegexPattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Invalid HostRegexToRegionMapping configuration: hostNameRegex is not a valid regex", patternSyntaxException);
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Invalid HostRegexToRegionMapping configuration: regionName must be non-empty");
        }
        this.regionName = string2;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public boolean isHostNameMatching(String string) {
        return this.hostNameRegexPattern.matcher(string).matches();
    }
}

