/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.auth;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.auth.SignerParams;
import com.amazonaws.auth.SignerTypeAware;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.regions.EndpointToRegion;
import java.net.URI;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient amazonWebServiceClient, Signer signer) {
        this.awsClient = amazonWebServiceClient;
        this.defaultSigner = signer;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        Request<?> request = signerProviderContext.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (signerProviderContext.isRedirect()) {
                return this.awsClient.getSignerByURI(signerProviderContext.getUri());
            }
            if (request != null && request.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null) {
                String string = request.getHandlerContext(HandlerContextKey.SIGNING_NAME);
                Signer signer = this.awsClient.getSignerByURI(signerProviderContext.getUri());
                if (signer instanceof ServiceAwareSigner && !this.isSignerOverridden()) {
                    ((ServiceAwareSigner)signer).setServiceName(string);
                    return signer;
                }
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams signerParams = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), signerParams);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest amazonWebServiceRequest) {
        return !(amazonWebServiceRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uRI) {
        String string = this.awsClient.getSignerRegionOverride();
        if (string == null) {
            string = EndpointToRegion.guessRegionNameForEndpoint(uRI.getHost(), this.awsClient.getEndpointPrefix());
        }
        return string;
    }
}

