/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.internal.BoundedLinkedHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@ThreadSafe
public final class FIFOCache<T> {
    private final BoundedLinkedHashMap<String, T> map;
    private final ReentrantReadWriteLock.ReadLock rlock;
    private final ReentrantReadWriteLock.WriteLock wlock;

    public FIFOCache(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxSize " + n + " must be at least 1");
        }
        this.map = new BoundedLinkedHashMap(n);
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.rlock = reentrantReadWriteLock.readLock();
        this.wlock = reentrantReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T add(String string, T t2) {
        this.wlock.lock();
        try {
            T t3 = this.map.put(string, t2);
            return t3;
        }
        finally {
            this.wlock.unlock();
        }
    }

    public T get(String string) {
        this.rlock.lock();
        try {
            Object v = this.map.get(string);
            return (T)v;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public int size() {
        this.rlock.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public int getMaxSize() {
        return this.map.getMaxSize();
    }

    public String toString() {
        this.rlock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.rlock.unlock();
        }
    }
}

