/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.internal.ConnectionUtils;
import com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.VersionInfoUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public abstract class EC2ResourceFetcher {
    private static final Log LOG = LogFactory.getLog(EC2ResourceFetcher.class);
    private final ConnectionUtils connectionUtils;
    private static final String USER_AGENT = VersionInfoUtils.getUserAgent();

    EC2ResourceFetcher() {
        this.connectionUtils = ConnectionUtils.getInstance();
    }

    @SdkTestInternalApi
    EC2ResourceFetcher(ConnectionUtils connectionUtils) {
        this.connectionUtils = connectionUtils;
    }

    public static EC2ResourceFetcher defaultResourceFetcher() {
        return DefaultEC2ResourceFetcher.DEFAULT_BASE_RESOURCE_FETCHER;
    }

    public abstract String readResource(URI var1, CredentialsEndpointRetryPolicy var2, Map<String, String> var3);

    public final String readResource(URI uRI) {
        return this.readResource(uRI, CredentialsEndpointRetryPolicy.NO_RETRY, null);
    }

    public final String readResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy) {
        return this.readResource(uRI, credentialsEndpointRetryPolicy, null);
    }

    final String doReadResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy, Map<String, String> map) {
        return this.doReadResource(uRI, credentialsEndpointRetryPolicy, map, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String doReadResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy, Map<String, String> map, String string) {
        int n = 0;
        InputStream inputStream2 = null;
        Map<String, String> map2 = this.addDefaultHeaders(map);
        while (true) {
            block9: {
                int n2;
                HttpURLConnection httpURLConnection;
                block8: {
                    httpURLConnection = this.connectionUtils.connectToEndpoint(uRI, map2, string);
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 != 200) break block8;
                    inputStream2 = httpURLConnection.getInputStream();
                    String string2 = IOUtils.toString(inputStream2);
                    IOUtils.closeQuietly(inputStream2, LOG);
                    return string2;
                }
                try {
                    if (n2 == 404) {
                        throw new SdkClientException("The requested metadata is not found at " + httpURLConnection.getURL());
                    }
                    if (credentialsEndpointRetryPolicy.shouldRetry(n++, CredentialsEndpointRetryParameters.builder().withStatusCode(n2).build())) break block9;
                    inputStream2 = httpURLConnection.getErrorStream();
                    this.handleErrorResponse(inputStream2, n2, httpURLConnection.getResponseMessage());
                }
                catch (IOException iOException) {
                    try {
                        if (!credentialsEndpointRetryPolicy.shouldRetry(n++, CredentialsEndpointRetryParameters.builder().withException(iOException).build())) {
                            throw new SdkClientException("Failed to connect to service endpoint: ", iOException);
                        }
                        LOG.debug("An IOException occurred when connecting to service endpoint: " + uRI + "\n Retrying to connect again.");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream2, LOG);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inputStream2, LOG);
                    continue;
                }
            }
            IOUtils.closeQuietly(inputStream2, LOG);
            continue;
            break;
        }
    }

    protected final Map<String, String> addDefaultHeaders(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null) {
            hashMap.putAll(map);
        }
        this.putIfAbsent(hashMap, "User-Agent", USER_AGENT);
        this.putIfAbsent(hashMap, "Accept", "*/*");
        this.putIfAbsent(hashMap, "Connection", "keep-alive");
        return hashMap;
    }

    private <K, V> void putIfAbsent(Map<K, V> map, K k, V v) {
        if (map.get(k) == null) {
            map.put(k, v);
        }
    }

    private void handleErrorResponse(InputStream inputStream2, int n, String string) throws IOException {
        Object object;
        String string2 = null;
        if (inputStream2 != null) {
            object = IOUtils.toString(inputStream2);
            try {
                JsonNode jsonNode = Jackson.jsonNodeOf((String)object);
                JsonNode jsonNode2 = jsonNode.get("code");
                JsonNode jsonNode3 = jsonNode.get("message");
                if (jsonNode2 != null && jsonNode3 != null) {
                    string2 = jsonNode2.asText();
                    string = jsonNode3.asText();
                }
            }
            catch (Exception exception) {
                LOG.debug("Unable to parse error stream");
            }
        }
        object = new AmazonServiceException(string);
        ((AmazonServiceException)object).setStatusCode(n);
        ((AmazonServiceException)object).setErrorCode(string2);
        throw object;
    }

    static final class DefaultEC2ResourceFetcher
    extends EC2ResourceFetcher {
        private static final DefaultEC2ResourceFetcher DEFAULT_BASE_RESOURCE_FETCHER = new DefaultEC2ResourceFetcher();

        DefaultEC2ResourceFetcher() {
        }

        @SdkTestInternalApi
        DefaultEC2ResourceFetcher(ConnectionUtils connectionUtils) {
            super(connectionUtils);
        }

        @Override
        public String readResource(URI uRI, CredentialsEndpointRetryPolicy credentialsEndpointRetryPolicy, Map<String, String> map) {
            return this.doReadResource(uRI, credentialsEndpointRetryPolicy, map);
        }
    }
}

