/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.timers.client;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.timers.client.ClientExecutionAbortTask;
import com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import com.amazonaws.util.ValidationUtils;
import java.util.concurrent.ScheduledFuture;
import org.apache.http.client.methods.HttpRequestBase;

@SdkInternalApi
public class ClientExecutionAbortTrackerTaskImpl
implements ClientExecutionAbortTrackerTask {
    private final ClientExecutionAbortTask task;
    private final ScheduledFuture<?> future;

    public ClientExecutionAbortTrackerTaskImpl(ClientExecutionAbortTask clientExecutionAbortTask, ScheduledFuture<?> scheduledFuture) {
        this.task = ValidationUtils.assertNotNull(clientExecutionAbortTask, "task");
        this.future = ValidationUtils.assertNotNull(scheduledFuture, "future");
    }

    @Override
    public void setCurrentHttpRequest(HttpRequestBase httpRequestBase) {
        this.task.setCurrentHttpRequest(httpRequestBase);
    }

    @Override
    public boolean hasTimeoutExpired() {
        return this.task.hasClientExecutionAborted();
    }

    @Override
    public boolean isEnabled() {
        return this.task.isEnabled();
    }

    @Override
    public void cancelTask() {
        this.future.cancel(false);
        this.task.cancel();
    }
}

