/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.protocol;

import com.amazonaws.internal.SdkMetricsSocket;
import com.amazonaws.internal.SdkSSLMetricsSocket;
import com.amazonaws.util.AWSRequestMetrics;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class SdkHttpRequestExecutor
extends HttpRequestExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doSendRequest(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws IOException, HttpException {
        Object object;
        AWSRequestMetrics aWSRequestMetrics = (AWSRequestMetrics)httpContext.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (aWSRequestMetrics == null) {
            return super.doSendRequest(httpRequest, httpClientConnection, httpContext);
        }
        if (httpClientConnection instanceof ManagedHttpClientConnection) {
            object = (ManagedHttpClientConnection)httpClientConnection;
            Socket socket = object.getSocket();
            if (socket instanceof SdkMetricsSocket) {
                SdkMetricsSocket sdkMetricsSocket = (SdkMetricsSocket)socket;
                sdkMetricsSocket.setMetrics(aWSRequestMetrics);
            } else if (socket instanceof SdkSSLMetricsSocket) {
                SdkSSLMetricsSocket sdkSSLMetricsSocket = (SdkSSLMetricsSocket)socket;
                sdkSSLMetricsSocket.setMetrics(aWSRequestMetrics);
            }
        }
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        try {
            object = super.doSendRequest(httpRequest, httpClientConnection, httpContext);
            return object;
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientSendRequestTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse doReceiveResponse(HttpRequest httpRequest, HttpClientConnection httpClientConnection, HttpContext httpContext) throws HttpException, IOException {
        AWSRequestMetrics aWSRequestMetrics = (AWSRequestMetrics)httpContext.getAttribute(AWSRequestMetrics.SIMPLE_NAME);
        if (aWSRequestMetrics == null) {
            return super.doReceiveResponse(httpRequest, httpClientConnection, httpContext);
        }
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        try {
            HttpResponse httpResponse = super.doReceiveResponse(httpRequest, httpClientConnection, httpContext);
            return httpResponse;
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
        }
    }
}

