/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn.ssl;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.http.apache.utils.HttpContextUtils;
import com.amazonaws.http.conn.ssl.MasterSecretValidators;
import com.amazonaws.http.conn.ssl.ShouldClearSslSessionPredicate;
import com.amazonaws.http.conn.ssl.TLSProtocol;
import com.amazonaws.internal.SdkMetricsSocket;
import com.amazonaws.internal.SdkSSLMetricsSocket;
import com.amazonaws.internal.SdkSSLSocket;
import com.amazonaws.internal.SdkSocket;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.util.JavaVersionParser;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public class SdkTLSSocketFactory
extends SSLConnectionSocketFactory {
    private static final Log LOG = LogFactory.getLog(SdkTLSSocketFactory.class);
    private final SSLContext sslContext;
    private final MasterSecretValidators.MasterSecretValidator masterSecretValidator;
    private final ShouldClearSslSessionPredicate shouldClearSslSessionsPredicate;

    public SdkTLSSocketFactory(SSLContext sSLContext, HostnameVerifier hostnameVerifier) {
        super(sSLContext, hostnameVerifier);
        if (sSLContext == null) {
            throw new IllegalArgumentException("sslContext must not be null. Use SSLContext.getDefault() if you are unsure.");
        }
        this.sslContext = sSLContext;
        this.masterSecretValidator = MasterSecretValidators.getMasterSecretValidator();
        this.shouldClearSslSessionsPredicate = new ShouldClearSslSessionPredicate(JavaVersionParser.getCurrentJavaVersion());
    }

    @Override
    public Socket createSocket(HttpContext httpContext) throws IOException {
        if (HttpContextUtils.disableSocketProxy(httpContext)) {
            return new Socket(Proxy.NO_PROXY);
        }
        return super.createSocket(httpContext);
    }

    @Override
    protected final void prepareSocket(SSLSocket sSLSocket) {
        Object[] objectArray2 = sSLSocket.getSupportedProtocols();
        Object[] objectArray3 = sSLSocket.getEnabledProtocols();
        if (LOG.isDebugEnabled()) {
            LOG.debug("socket.getSupportedProtocols(): " + Arrays.toString(objectArray2) + ", socket.getEnabledProtocols(): " + Arrays.toString(objectArray3));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray2 != null) {
            TLSProtocol[] objectArray = TLSProtocol.values();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].getProtocolName();
                if (!this.existsIn(string, (String[])objectArray2)) continue;
                arrayList.add(string);
            }
        }
        if (objectArray3 != null) {
            for (Object object : objectArray3) {
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
        }
        if (arrayList.size() > 0) {
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            sSLSocket.setEnabledProtocols((String[])objectArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS protocol enabled for SSL handshake: " + Arrays.toString(objectArray));
            }
        }
    }

    private boolean existsIn(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(int n, Socket socket, HttpHost httpHost, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpContext httpContext) throws IOException {
        Socket socket2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to " + inetSocketAddress.getAddress() + ":" + inetSocketAddress.getPort());
        }
        try {
            socket2 = super.connectSocket(n, socket, httpHost, inetSocketAddress, inetSocketAddress2, httpContext);
            if (!this.masterSecretValidator.isMasterSecretValid(socket2)) {
                throw this.log(new IllegalStateException("Invalid SSL master secret"));
            }
        }
        catch (SSLException sSLException) {
            if (this.shouldClearSslSessionsPredicate.test(sSLException)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connection failed due to SSL error, clearing TLS session cache", sSLException);
                }
                this.clearSessionCache(this.sslContext.getClientSessionContext(), inetSocketAddress);
            }
            throw sSLException;
        }
        if (socket2 instanceof SSLSocket) {
            SdkSSLSocket sdkSSLSocket = new SdkSSLSocket((SSLSocket)socket2);
            return AwsSdkMetrics.isHttpSocketReadMetricEnabled() ? new SdkSSLMetricsSocket(sdkSSLSocket) : sdkSSLSocket;
        }
        SdkSocket sdkSocket = new SdkSocket(socket2);
        return AwsSdkMetrics.isHttpSocketReadMetricEnabled() ? new SdkMetricsSocket(sdkSocket) : sdkSocket;
    }

    private void clearSessionCache(SSLSessionContext sSLSessionContext, InetSocketAddress inetSocketAddress) {
        String string = inetSocketAddress.getHostName();
        int n = inetSocketAddress.getPort();
        Enumeration<byte[]> enumeration = sSLSessionContext.getIds();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            byte[] byArray = enumeration.nextElement();
            SSLSession sSLSession = sSLSessionContext.getSession(byArray);
            if (sSLSession == null || sSLSession.getPeerHost() == null || !sSLSession.getPeerHost().equalsIgnoreCase(string) || sSLSession.getPeerPort() != n) continue;
            sSLSession.invalidate();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Invalidated session " + sSLSession);
        }
    }

    private <T extends Throwable> T log(T t2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("", t2);
        }
        return t2;
    }
}

