/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache;

import com.amazonaws.Protocol;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private String[] hostPatterns;

    public SdkProxyRoutePlanner(String string, int n, Protocol protocol, String string2) {
        super(DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(string, n, protocol.toString());
        this.parseNonProxyHosts(string2);
    }

    private void parseNonProxyHosts(String string) {
        if (!StringUtils.isNullOrEmpty(string)) {
            String[] stringArray = string.split("\\|");
            this.hostPatterns = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.hostPatterns[i] = stringArray[i].toLowerCase().replace("*", ".*?");
            }
        }
    }

    boolean doesTargetMatchNonProxyHosts(HttpHost httpHost) {
        if (this.hostPatterns == null) {
            return false;
        }
        String string = httpHost.getHostName().toLowerCase();
        for (String string2 : this.hostPatterns) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(httpHost) ? null : this.proxy;
    }
}

