/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.VoidStaxUnmarshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.io.EmptyInputStream;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadXML;
    private static final Log log = LogFactory.getLog("com.amazonaws.request");

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> unmarshaller, boolean bl, boolean bl2) {
        this.responseUnmarshaller = unmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
        this.needsConnectionLeftOpen = bl;
        this.isPayloadXML = bl2;
    }

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> unmarshaller) {
        this(unmarshaller, false, true);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse httpResponse) throws Exception {
        XMLEventReader xMLEventReader;
        log.trace("Parsing service response XML");
        InputStream inputStream2 = httpResponse.getContent();
        if (inputStream2 == null || !this.shouldParsePayloadAsXml()) {
            inputStream2 = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        } else if (inputStream2 instanceof SdkFilterInputStream && ((SdkFilterInputStream)inputStream2).getDelegateStream() instanceof EmptyInputStream) {
            inputStream2 = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        try {
            xMLEventReader = XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw this.handleXmlStreamException(xMLStreamException);
        }
        try {
            AmazonWebServiceResponse<T> amazonWebServiceResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(xMLEventReader, httpResponse.getHeaders(), httpResponse);
            staxUnmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            staxUnmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(staxUnmarshallerContext);
            T t2 = this.responseUnmarshaller.unmarshall(staxUnmarshallerContext);
            amazonWebServiceResponse.setResult(t2);
            Map<String, String> map = staxUnmarshallerContext.getMetadata();
            Map<String, String> map2 = httpResponse.getHeaders();
            if (map2 != null) {
                if (map2.get("x-amzn-RequestId") != null) {
                    map.put("AWS_REQUEST_ID", map2.get("x-amzn-RequestId"));
                }
                if (map2.get("x-amz-id-2") != null) {
                    map.put("AWS_EXTENDED_REQUEST_ID", map2.get("x-amz-id-2"));
                }
            }
            amazonWebServiceResponse.setResponseMetadata(this.getResponseMetadata(map));
            log.trace("Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse2 = amazonWebServiceResponse;
            return amazonWebServiceResponse2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw this.handleXmlStreamException(xMLStreamException);
        }
        finally {
            try {
                xMLEventReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                log.warn("Error closing xml parser", xMLStreamException);
            }
        }
    }

    private Exception handleXmlStreamException(XMLStreamException xMLStreamException) throws Exception {
        if (xMLStreamException.getNestedException() instanceof IOException) {
            return new IOException(xMLStreamException);
        }
        return xMLStreamException;
    }

    protected ResponseMetadata getResponseMetadata(Map<String, String> map) {
        return new ResponseMetadata(map);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext staxUnmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsXml() {
        return !this.needsConnectionLeftOpen && this.isPayloadXML;
    }
}

