/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.http.HttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class SdkHttpMetadata {
    private final Map<String, List<String>> allHeaders;
    private final Map<String, String> httpHeaders;
    private final int httpStatusCode;

    private SdkHttpMetadata(Map<String, String> map, Map<String, List<String>> map2, int n) {
        this.httpHeaders = Collections.unmodifiableMap(map);
        this.allHeaders = this.unmodifiableHeaders(map2);
        this.httpStatusCode = n;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Map<String, List<String>> getAllHttpHeaders() {
        return this.allHeaders;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static SdkHttpMetadata from(HttpResponse httpResponse) {
        return new SdkHttpMetadata(httpResponse.getHeaders(), httpResponse.getAllHeaders(), httpResponse.getStatusCode());
    }

    private Map<String, List<String>> unmodifiableHeaders(Map<String, List<String>> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

