/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.util.AWSRequestMetrics;

@SdkInternalApi
class AwsErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private final HttpResponseHandler<AmazonServiceException> delegate;
    private final AWSRequestMetrics awsRequestMetrics;
    private final ClientConfiguration clientConfiguration;

    AwsErrorResponseHandler(HttpResponseHandler<AmazonServiceException> httpResponseHandler, AWSRequestMetrics aWSRequestMetrics, ClientConfiguration clientConfiguration) {
        this.delegate = httpResponseHandler;
        this.awsRequestMetrics = aWSRequestMetrics;
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AmazonServiceException handle(HttpResponse httpResponse) throws Exception {
        AmazonServiceException amazonServiceException = this.handleAse(httpResponse);
        amazonServiceException.setStatusCode(httpResponse.getStatusCode());
        amazonServiceException.setServiceName(httpResponse.getRequest().getServiceName());
        amazonServiceException.setProxyHost(this.clientConfiguration.getProxyHost());
        this.awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, (Object)amazonServiceException.getRequestId()).addPropertyWith(AWSRequestMetrics.Field.AWSErrorCode, (Object)amazonServiceException.getErrorCode()).addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)amazonServiceException.getStatusCode());
        return amazonServiceException;
    }

    private AmazonServiceException handleAse(HttpResponse httpResponse) throws Exception {
        int n = httpResponse.getStatusCode();
        try {
            return this.delegate.handle(httpResponse);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception exception) {
            if (n == 413) {
                AmazonServiceException amazonServiceException = new AmazonServiceException("Request entity too large");
                amazonServiceException.setServiceName(httpResponse.getRequest().getServiceName());
                amazonServiceException.setStatusCode(n);
                amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Client);
                amazonServiceException.setErrorCode("Request entity too large");
                return amazonServiceException;
            }
            if (n >= 500 && n < 600) {
                AmazonServiceException amazonServiceException = new AmazonServiceException(httpResponse.getStatusText());
                amazonServiceException.setServiceName(httpResponse.getRequest().getServiceName());
                amazonServiceException.setStatusCode(n);
                amazonServiceException.setErrorType(AmazonServiceException.ErrorType.Service);
                amazonServiceException.setErrorCode(httpResponse.getStatusText());
                return amazonServiceException;
            }
            throw exception;
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }
}

