/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.RequestConfig;
import com.amazonaws.ResetException;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalTime;
import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CanHandleNullCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.HandlerAfterAttemptContext;
import com.amazonaws.handlers.HandlerBeforeAttemptContext;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.AwsErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.http.UnreliableTestConfig;
import com.amazonaws.http.apache.client.impl.ApacheHttpClientFactory;
import com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.http.apache.request.impl.ApacheHttpRequestFactory;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.http.client.HttpClientFactory;
import com.amazonaws.http.exception.HttpRequestTimeoutException;
import com.amazonaws.http.request.HttpRequestFactory;
import com.amazonaws.http.response.AwsResponseHandlerAdapter;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import com.amazonaws.http.timers.client.ClientExecutionTimeoutException;
import com.amazonaws.http.timers.client.ClientExecutionTimer;
import com.amazonaws.http.timers.client.SdkInterruptedException;
import com.amazonaws.http.timers.request.HttpRequestAbortTaskTracker;
import com.amazonaws.http.timers.request.HttpRequestTimer;
import com.amazonaws.internal.AmazonWebServiceRequestAdapter;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkBufferedInputStream;
import com.amazonaws.internal.SdkRequestRetryHeaderProvider;
import com.amazonaws.internal.TokenBucket;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.monitoring.internal.ClientSideMonitoringRequestHandler;
import com.amazonaws.retry.ClockSkewAdjuster;
import com.amazonaws.retry.RetryMode;
import com.amazonaws.retry.RetryPolicyAdapter;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.retry.internal.AuthRetryParameters;
import com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsClientSideMonitoringMetrics;
import com.amazonaws.util.CapacityManager;
import com.amazonaws.util.CollectionUtils;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.MetadataCache;
import com.amazonaws.util.NullResponseMetadataCache;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.RuntimeHttpUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UnreliableFilterInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public class AmazonHttpClient {
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_SDK_TRANSACTION_ID = "amz-sdk-invocation-id";
    public static final String HEADER_SDK_RETRY_INFO = "amz-sdk-retry";
    private static final String TRACE_ID_HEADER = "X-Amzn-Trace-Id";
    static final Log log;
    @SdkInternalApi
    public static final Log requestLog;
    private static final HttpClientFactory<ConnectionManagerAwareHttpClient> httpClientFactory;
    private static UnreliableTestConfig unreliableTestConfig;
    private static final int THROTTLED_RETRY_COST = 5;
    private static final int TIMEOUT_RETRY_COST = 10;
    private final ClockSkewAdjuster clockSkewAdjuster = new ClockSkewAdjuster();
    private final HttpRequestFactory<HttpRequestBase> httpRequestFactory = new ApacheHttpRequestFactory();
    private ConnectionManagerAwareHttpClient httpClient;
    private final ClientConfiguration config;
    private final RetryPolicy retryPolicy;
    private final HttpClientSettings httpClientSettings;
    private final MetadataCache responseMetadataCache;
    private final HttpRequestTimer httpRequestTimer;
    private final CapacityManager retryCapacity;
    private TokenBucket tokenBucket;
    private final ClientExecutionTimer clientExecutionTimer;
    private final RequestMetricCollector requestMetricCollector;
    private final Random random = new Random();
    private volatile int timeOffset = SDKGlobalTime.getGlobalTimeOffset();
    private final RetryMode retryMode;
    private final SdkRequestRetryHeaderProvider sdkRequestHeaderProvider;

    public AmazonHttpClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonHttpClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(clientConfiguration, requestMetricCollector, false);
    }

    public AmazonHttpClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, boolean bl) {
        this(clientConfiguration, requestMetricCollector, bl, false);
    }

    public AmazonHttpClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, boolean bl, boolean bl2) {
        this(clientConfiguration, null, requestMetricCollector, bl, bl2);
    }

    private AmazonHttpClient(ClientConfiguration clientConfiguration, RetryPolicy retryPolicy, RequestMetricCollector requestMetricCollector, boolean bl, boolean bl2) {
        this(clientConfiguration, retryPolicy, requestMetricCollector, HttpClientSettings.adapt(clientConfiguration, bl, bl2));
        this.httpClient = httpClientFactory.create(this.httpClientSettings);
    }

    @SdkTestInternalApi
    public AmazonHttpClient(ClientConfiguration clientConfiguration, ConnectionManagerAwareHttpClient connectionManagerAwareHttpClient, RequestMetricCollector requestMetricCollector, TokenBucket tokenBucket) {
        this(clientConfiguration, null, requestMetricCollector, HttpClientSettings.adapt(clientConfiguration, false));
        this.httpClient = connectionManagerAwareHttpClient;
        this.tokenBucket = tokenBucket;
    }

    private AmazonHttpClient(ClientConfiguration clientConfiguration, RetryPolicy retryPolicy, RequestMetricCollector requestMetricCollector, HttpClientSettings httpClientSettings) {
        this.config = clientConfiguration;
        this.retryPolicy = retryPolicy == null ? new RetryPolicyAdapter(clientConfiguration.getRetryPolicy(), clientConfiguration) : retryPolicy;
        this.retryMode = clientConfiguration.getRetryMode() == null ? clientConfiguration.getRetryPolicy().getRetryMode() : clientConfiguration.getRetryMode();
        this.httpClientSettings = httpClientSettings;
        this.requestMetricCollector = requestMetricCollector;
        this.responseMetadataCache = clientConfiguration.getCacheResponseMetadata() ? new ResponseMetadataCache(clientConfiguration.getResponseMetadataCacheSize()) : new NullResponseMetadataCache();
        this.httpRequestTimer = new HttpRequestTimer();
        this.clientExecutionTimer = new ClientExecutionTimer();
        int n = clientConfiguration.useThrottledRetries() ? 5 * this.config.getMaxConsecutiveRetriesBeforeThrottling() : -1;
        this.retryCapacity = new CapacityManager(n);
        this.tokenBucket = new TokenBucket();
        this.sdkRequestHeaderProvider = new SdkRequestRetryHeaderProvider(this.config, this.retryPolicy, this.clockSkewAdjuster);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isTemporaryRedirect(org.apache.http.HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        return n == 307 && httpResponse.getHeaders("Location") != null && httpResponse.getHeaders("Location").length > 0;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public void shutdown() {
        this.clientExecutionTimer.shutdown();
        this.httpRequestTimer.shutdown();
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getHttpClientConnectionManager());
        this.httpClient.getHttpClientConnectionManager().shutdown();
    }

    static void configUnreliableTestConditions(UnreliableTestConfig unreliableTestConfig) {
        AmazonHttpClient.unreliableTestConfig = unreliableTestConfig;
    }

    @SdkTestInternalApi
    public HttpRequestTimer getHttpRequestTimer() {
        return this.httpRequestTimer;
    }

    @SdkTestInternalApi
    public ClientExecutionTimer getClientExecutionTimer() {
        return this.clientExecutionTimer;
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.responseMetadataCache.get(amazonWebServiceRequest);
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Deprecated
    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> httpResponseHandler, HttpResponseHandler<AmazonServiceException> httpResponseHandler2, ExecutionContext executionContext) {
        return this.execute(request, httpResponseHandler, httpResponseHandler2, executionContext, new AmazonWebServiceRequestAdapter(request.getOriginalRequest()));
    }

    @SdkInternalApi
    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> httpResponseHandler, HttpResponseHandler<AmazonServiceException> httpResponseHandler2, ExecutionContext executionContext, RequestConfig requestConfig) {
        AwsResponseHandlerAdapter<T> awsResponseHandlerAdapter = new AwsResponseHandlerAdapter<T>(this.getNonNullResponseHandler(httpResponseHandler), request, executionContext.getAwsRequestMetrics(), this.responseMetadataCache);
        return this.requestExecutionBuilder().request(request).requestConfig(requestConfig).errorResponseHandler(new AwsErrorResponseHandler(httpResponseHandler2, executionContext.getAwsRequestMetrics(), this.config)).executionContext(executionContext).execute(awsResponseHandlerAdapter);
    }

    private <T> HttpResponseHandler<T> getNonNullResponseHandler(HttpResponseHandler<T> httpResponseHandler) {
        if (httpResponseHandler != null) {
            return httpResponseHandler;
        }
        return new HttpResponseHandler<T>(){

            @Override
            public T handle(HttpResponse httpResponse) throws Exception {
                return null;
            }

            @Override
            public boolean needsConnectionLeftOpen() {
                return false;
            }
        };
    }

    public RequestExecutionBuilder requestExecutionBuilder() {
        return new RequestExecutionBuilderImpl();
    }

    static {
        String string;
        log = LogFactory.getLog(AmazonHttpClient.class);
        requestLog = LogFactory.getLog("com.amazonaws.request");
        httpClientFactory = new ApacheHttpClientFactory();
        List<String> list = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17", "1.6.0_65", "1.7.0_45");
        if (list.contains(string = System.getProperty("java.version"))) {
            log.warn("Detected a possible problem with the current JVM version (" + string + ").  If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update.");
        }
    }

    private class RequestExecutor<Output> {
        private final Request<?> request;
        private final RequestConfig requestConfig;
        private final HttpResponseHandler<? extends SdkBaseException> errorResponseHandler;
        private final HttpResponseHandler<Output> responseHandler;
        private final ExecutionContext executionContext;
        private final List<RequestHandler2> requestHandler2s;
        private final AWSRequestMetrics awsRequestMetrics;
        private RequestHandler2 csmRequestHandler;

        private RequestExecutor(Request<?> request, RequestConfig requestConfig, HttpResponseHandler<? extends SdkBaseException> httpResponseHandler, HttpResponseHandler<Output> httpResponseHandler2, ExecutionContext executionContext, List<RequestHandler2> list) {
            this.request = request;
            this.requestConfig = requestConfig;
            this.errorResponseHandler = httpResponseHandler;
            this.responseHandler = httpResponseHandler2;
            this.executionContext = executionContext;
            this.requestHandler2s = list;
            this.awsRequestMetrics = executionContext.getAwsRequestMetrics();
            for (RequestHandler2 requestHandler2 : list) {
                if (!(requestHandler2 instanceof ClientSideMonitoringRequestHandler)) continue;
                this.csmRequestHandler = requestHandler2;
                break;
            }
        }

        private Response<Output> execute() {
            if (this.executionContext == null) {
                throw new SdkClientException("Internal SDK Error: No execution context parameter specified.");
            }
            try {
                Response<Output> response = this.executeWithTimer();
                return response;
            }
            catch (InterruptedException interruptedException) {
                throw this.handleInterruptedException(interruptedException);
            }
            catch (AbortedException abortedException) {
                throw this.handleAbortedException(abortedException);
            }
            finally {
                if (this.executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
                    Thread.interrupted();
                }
            }
        }

        private Response<Output> executeWithTimer() throws InterruptedException {
            Response<Output> response;
            ClientExecutionAbortTrackerTask clientExecutionAbortTrackerTask = AmazonHttpClient.this.clientExecutionTimer.startTimer(this.getClientExecutionTimeout(this.requestConfig));
            try {
                this.executionContext.setClientExecutionTrackerTask(clientExecutionAbortTrackerTask);
                response = this.doExecute();
            }
            finally {
                this.executionContext.getClientExecutionTrackerTask().cancelTask();
            }
            return response;
        }

        private Response<Output> doExecute() throws InterruptedException {
            this.runBeforeRequestHandlers();
            this.setSdkTransactionId(this.request);
            this.setUserAgent(this.request);
            this.setTraceId(this.request);
            ProgressListener progressListener = this.requestConfig.getProgressListener();
            this.request.getHeaders().putAll(AmazonHttpClient.this.config.getHeaders());
            this.request.getHeaders().putAll(this.requestConfig.getCustomRequestHeaders());
            this.mergeQueryParameters(this.requestConfig.getCustomQueryParameters());
            Response<Output> response = null;
            InputStream inputStream2 = this.request.getContent();
            InputStream inputStream3 = this.beforeRequest();
            InputStream inputStream4 = inputStream3 == null ? null : (InputStream)ReleasableInputStream.wrap(inputStream3).disableClose();
            this.request.setContent(inputStream4);
            try {
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.CLIENT_REQUEST_STARTED_EVENT);
                response = this.executeHelper();
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.CLIENT_REQUEST_SUCCESS_EVENT);
                this.awsRequestMetrics.endEvent(AwsClientSideMonitoringMetrics.ApiCallLatency);
                this.awsRequestMetrics.getTimingInfo().endTiming();
                this.afterResponse(response);
                Response<Output> response2 = response;
                return response2;
            }
            catch (AmazonClientException amazonClientException) {
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.CLIENT_REQUEST_FAILED_EVENT);
                this.awsRequestMetrics.endEvent(AwsClientSideMonitoringMetrics.ApiCallLatency);
                this.afterError(response, amazonClientException);
                throw amazonClientException;
            }
            finally {
                this.closeQuietlyForRuntimeExceptions(inputStream3, log);
                this.request.setContent(inputStream2);
            }
        }

        private void closeQuietlyForRuntimeExceptions(Closeable closeable, Log log) {
            block2: {
                try {
                    IOUtils.closeQuietly(closeable, log);
                }
                catch (RuntimeException runtimeException) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Unable to close closeable", runtimeException);
                }
            }
        }

        private void runBeforeRequestHandlers() {
            AWSCredentials aWSCredentials = this.getCredentialsFromContext();
            this.request.addHandlerContext(HandlerContextKey.AWS_CREDENTIALS, aWSCredentials);
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                if (requestHandler2 instanceof CredentialsRequestHandler) {
                    ((CredentialsRequestHandler)requestHandler2).setCredentials(aWSCredentials);
                }
                requestHandler2.beforeRequest(this.request);
            }
        }

        private RuntimeException handleInterruptedException(InterruptedException interruptedException) {
            if (interruptedException instanceof SdkInterruptedException && ((SdkInterruptedException)interruptedException).getResponse() != null) {
                ((SdkInterruptedException)interruptedException).getResponse().getHttpResponse().getHttpRequest().abort();
            }
            if (this.executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
                Thread.interrupted();
                ClientExecutionTimeoutException clientExecutionTimeoutException = new ClientExecutionTimeoutException();
                this.reportClientExecutionTimeout(clientExecutionTimeoutException);
                return clientExecutionTimeoutException;
            }
            Thread.currentThread().interrupt();
            return new AbortedException(interruptedException);
        }

        private RuntimeException handleAbortedException(AbortedException abortedException) {
            if (this.executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
                Thread.interrupted();
                ClientExecutionTimeoutException clientExecutionTimeoutException = new ClientExecutionTimeoutException();
                this.reportClientExecutionTimeout(clientExecutionTimeoutException);
                return clientExecutionTimeoutException;
            }
            Thread.currentThread().interrupt();
            return abortedException;
        }

        private void reportClientExecutionTimeout(ClientExecutionTimeoutException clientExecutionTimeoutException) {
            if (this.csmRequestHandler != null) {
                this.csmRequestHandler.afterError(this.request, null, clientExecutionTimeoutException);
            }
        }

        private void checkInterrupted() throws InterruptedException {
            this.checkInterrupted(null);
        }

        private void checkInterrupted(Response<?> response) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new SdkInterruptedException(response);
            }
        }

        private void mergeQueryParameters(Map<String, List<String>> map) {
            Map<String, List<String>> map2 = this.request.getParameters();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<String> list = entry.getValue();
                map2.put(string, CollectionUtils.mergeLists(map2.get(string), list));
            }
        }

        private InputStream beforeRequest() {
            ProgressListener progressListener = this.requestConfig.getProgressListener();
            this.reportContentLength(progressListener);
            if (this.request.getContent() == null) {
                return null;
            }
            InputStream inputStream2 = this.monitorStreamProgress(progressListener, this.buffer(this.makeResettable(this.request.getContent())));
            if (unreliableTestConfig == null) {
                return inputStream2;
            }
            return this.wrapWithUnreliableStream(inputStream2);
        }

        private void reportContentLength(ProgressListener progressListener) {
            Map<String, String> map = this.request.getHeaders();
            String string = map.get("Content-Length");
            if (string != null) {
                try {
                    long l = Long.parseLong(string);
                    SDKProgressPublisher.publishRequestContentLength(progressListener, l);
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn("Cannot parse the Content-Length header of the request.");
                }
            }
        }

        private InputStream makeResettable(InputStream inputStream2) {
            block3: {
                if (!inputStream2.markSupported() && inputStream2 instanceof FileInputStream) {
                    try {
                        return new ResettableInputStream((FileInputStream)inputStream2);
                    }
                    catch (IOException iOException) {
                        if (!log.isDebugEnabled()) break block3;
                        log.debug("For the record; ignore otherwise", iOException);
                    }
                }
            }
            return inputStream2;
        }

        private InputStream buffer(InputStream inputStream2) {
            if (!inputStream2.markSupported()) {
                inputStream2 = new SdkBufferedInputStream(inputStream2);
            }
            return inputStream2;
        }

        private InputStream monitorStreamProgress(ProgressListener progressListener, InputStream inputStream2) {
            return ProgressInputStream.inputStreamForRequest(inputStream2, progressListener);
        }

        private InputStream wrapWithUnreliableStream(InputStream inputStream2) {
            return new UnreliableFilterInputStream(inputStream2, unreliableTestConfig.isFakeIOException()).withBytesReadBeforeException(unreliableTestConfig.getBytesReadBeforeException()).withMaxNumErrors(unreliableTestConfig.getMaxNumErrors()).withResetIntervalBeforeException(unreliableTestConfig.getResetIntervalBeforeException());
        }

        private void afterError(Response<?> response, AmazonClientException amazonClientException) throws InterruptedException {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.afterError(this.request, response, amazonClientException);
                this.checkInterrupted(response);
            }
        }

        private <T> void afterResponse(Response<T> response) throws InterruptedException {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.afterResponse(this.request, response);
                this.checkInterrupted(response);
            }
        }

        private <T> void beforeAttempt(HandlerBeforeAttemptContext handlerBeforeAttemptContext) throws InterruptedException {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.beforeAttempt(handlerBeforeAttemptContext);
                this.checkInterrupted();
            }
        }

        private <T> void afterAttempt(HandlerAfterAttemptContext handlerAfterAttemptContext) throws InterruptedException {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.afterAttempt(handlerAfterAttemptContext);
                this.checkInterrupted(handlerAfterAttemptContext.getResponse());
            }
        }

        private Response<Output> executeHelper() throws InterruptedException {
            int n;
            this.awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.RequestType, (Object)this.requestConfig.getRequestType()).addPropertyWith(AWSRequestMetrics.Field.ServiceName, (Object)this.request.getServiceName()).addPropertyWith(AWSRequestMetrics.Field.ServiceEndpoint, (Object)this.request.getEndpoint());
            LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>(this.request.getParameters());
            HashMap<String, String> hashMap = new HashMap<String, String>(this.request.getHeaders());
            ExecOneRequestParams execOneRequestParams = new ExecOneRequestParams();
            InputStream inputStream2 = this.request.getContent();
            if (inputStream2 != null && inputStream2.markSupported() && !(inputStream2 instanceof BufferedInputStream)) {
                n = this.requestConfig.getRequestClientOptions().getReadLimit();
                inputStream2.mark(n);
            }
            this.awsRequestMetrics.startEvent(AwsClientSideMonitoringMetrics.ApiCallLatency);
            while (true) {
                Object object;
                Object object2;
                Object object3;
                this.checkInterrupted();
                if (inputStream2 instanceof BufferedInputStream && inputStream2.markSupported()) {
                    n = this.requestConfig.getRequestClientOptions().getReadLimit();
                    inputStream2.mark(n);
                }
                execOneRequestParams.initPerRetry();
                URI uRI = execOneRequestParams.redirectedURI;
                if (uRI != null) {
                    object3 = uRI.getScheme();
                    object2 = object3 == null ? "" : (String)object3 + "://";
                    String string = uRI.getAuthority();
                    object = uRI.getPath();
                    this.request.setEndpoint(URI.create((String)object2 + string));
                    this.request.setResourcePath(SdkHttpUtils.urlEncode((String)object, true));
                    this.awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.RedirectLocation, (Object)uRI.toString());
                }
                if (execOneRequestParams.authRetryParam != null) {
                    this.request.setEndpoint(execOneRequestParams.authRetryParam.getEndpointForRetry());
                }
                this.awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)execOneRequestParams.requestCount);
                if (execOneRequestParams.isRetry()) {
                    this.request.setParameters(linkedHashMap);
                    this.request.setHeaders(hashMap);
                    this.request.setContent(inputStream2);
                }
                object3 = null;
                object2 = null;
                boolean bl = false;
                try {
                    object = HandlerBeforeAttemptContext.builder().withRequest(this.request).build();
                    this.beforeAttempt((HandlerBeforeAttemptContext)object);
                    object3 = this.executeOneRequest(execOneRequestParams);
                    object2 = execOneRequestParams.retriedException;
                    if (object3 == null) continue;
                    Object object4 = object3;
                    return object4;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    this.handleRetryableException(execOneRequestParams, iOException);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    object2 = interruptedException;
                    bl = true;
                    throw interruptedException;
                }
                catch (RuntimeException runtimeException) {
                    object2 = runtimeException;
                    bl = true;
                    throw this.lastReset(this.captureExceptionMetrics(runtimeException));
                }
                catch (Error error) {
                    bl = true;
                    throw this.lastReset(this.captureExceptionMetrics(error));
                }
                finally {
                    if ((!execOneRequestParams.leaveHttpConnectionOpen || bl) && execOneRequestParams.apacheResponse != null && (object = execOneRequestParams.apacheResponse.getEntity()) != null) {
                        try {
                            IOUtils.closeQuietly(object.getContent(), log);
                        }
                        catch (IOException iOException) {
                            log.warn("Cannot close the response content.", iOException);
                        }
                    }
                    object = HandlerAfterAttemptContext.builder().withRequest(this.request).withResponse((Response<?>)object3).withException((Exception)object2).build();
                    this.afterAttempt((HandlerAfterAttemptContext)object);
                    continue;
                }
                break;
            }
        }

        private void handleRetryableException(ExecOneRequestParams execOneRequestParams, Exception exception) {
            this.captureExceptionMetrics(exception);
            this.awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
            SdkClientException sdkClientException = !(exception instanceof SdkClientException) ? new SdkClientException("Unable to execute HTTP request: " + exception.getMessage(), exception) : (SdkClientException)exception;
            boolean bl = this.shouldRetry(execOneRequestParams, sdkClientException);
            if (log.isTraceEnabled()) {
                log.trace(sdkClientException.getMessage() + (bl ? " Request will be retried." : ""), exception);
            } else if (log.isDebugEnabled()) {
                log.debug(sdkClientException.getMessage() + (bl ? " Request will be retried." : ""));
            }
            if (!bl) {
                throw this.lastReset(sdkClientException);
            }
            execOneRequestParams.retriedException = sdkClientException;
        }

        private <T extends Throwable> T lastReset(T t2) {
            try {
                InputStream inputStream2 = this.request.getContent();
                if (inputStream2 != null && inputStream2.markSupported()) {
                    inputStream2.reset();
                }
            }
            catch (Exception exception) {
                log.debug("FYI: failed to reset content inputstream before throwing up", exception);
            }
            return t2;
        }

        private AWSCredentials getCredentialsFromContext() {
            AWSCredentialsProvider aWSCredentialsProvider = this.executionContext.getCredentialsProvider();
            AWSCredentials aWSCredentials = null;
            if (aWSCredentialsProvider != null) {
                this.awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
                try {
                    aWSCredentials = aWSCredentialsProvider.getCredentials();
                }
                finally {
                    this.awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
                }
            }
            return aWSCredentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response<Output> executeOneRequest(ExecOneRequestParams execOneRequestParams) throws IOException, InterruptedException {
            if (execOneRequestParams.isRetry()) {
                this.resetRequestInputStream(this.request, execOneRequestParams.retriedException);
            }
            this.checkInterrupted();
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((execOneRequestParams.isRetry() ? "Retrying " : "Sending ") + "Request: " + this.request);
            }
            AWSCredentials aWSCredentials = this.getCredentialsFromContext();
            ProgressListener progressListener = this.requestConfig.getProgressListener();
            this.getSendToken();
            if (execOneRequestParams.isRetry()) {
                this.pauseBeforeRetry(execOneRequestParams, progressListener);
            }
            this.updateRetryHeaderInfo(this.request, execOneRequestParams);
            AmazonHttpClient.this.sdkRequestHeaderProvider.addSdkRequestRetryHeader(this.request, execOneRequestParams.requestCount);
            execOneRequestParams.newSigner(this.request, this.executionContext);
            if (execOneRequestParams.signer != null && (aWSCredentials != null || execOneRequestParams.signer instanceof CanHandleNullCredentials)) {
                this.awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
                try {
                    if (AmazonHttpClient.this.timeOffset != 0) {
                        this.request.setTimeOffset(AmazonHttpClient.this.timeOffset);
                    }
                    execOneRequestParams.signer.sign(this.request, aWSCredentials);
                }
                finally {
                    this.awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
                }
            }
            this.checkInterrupted();
            execOneRequestParams.newApacheRequest(AmazonHttpClient.this.httpRequestFactory, this.request, AmazonHttpClient.this.httpClientSettings);
            this.captureConnectionPoolMetrics();
            HttpClientContext httpClientContext = ApacheUtils.newClientContext(AmazonHttpClient.this.httpClientSettings, ImmutableMapParameter.of(AWSRequestMetrics.SIMPLE_NAME, this.awsRequestMetrics));
            execOneRequestParams.resetBeforeHttpRequest();
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.HTTP_REQUEST_STARTED_EVENT);
            this.awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
            this.awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RetryCapacityConsumed, (long)AmazonHttpClient.this.retryCapacity.consumedCapacity());
            this.executionContext.getClientExecutionTrackerTask().setCurrentHttpRequest(execOneRequestParams.apacheRequest);
            HttpRequestAbortTaskTracker httpRequestAbortTaskTracker = AmazonHttpClient.this.httpRequestTimer.startTimer(execOneRequestParams.apacheRequest, this.getRequestTimeout(this.requestConfig));
            try {
                execOneRequestParams.apacheResponse = AmazonHttpClient.this.httpClient.execute((HttpUriRequest)execOneRequestParams.apacheRequest, httpClientContext);
                if (this.shouldBufferHttpEntity(this.responseHandler.needsConnectionLeftOpen(), this.executionContext, execOneRequestParams, httpRequestAbortTaskTracker)) {
                    execOneRequestParams.apacheResponse.setEntity(new BufferedHttpEntity(execOneRequestParams.apacheResponse.getEntity()));
                }
            }
            catch (IOException iOException) {
                if (this.executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
                    throw new InterruptedException();
                }
                if (httpRequestAbortTaskTracker.httpRequestAborted()) {
                    if (iOException instanceof RequestAbortedException) {
                        Thread.interrupted();
                    }
                    throw new HttpRequestTimeoutException(iOException);
                }
                throw iOException;
            }
            finally {
                httpRequestAbortTaskTracker.cancelTask();
                this.awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
            }
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.HTTP_REQUEST_COMPLETED_EVENT);
            StatusLine statusLine = execOneRequestParams.apacheResponse.getStatusLine();
            int n = statusLine == null ? -1 : statusLine.getStatusCode();
            AmazonHttpClient.this.clockSkewAdjuster.updateEstimatedSkew(new ClockSkewAdjuster.AdjustmentRequest().clientRequest(this.request).serviceResponse(execOneRequestParams.apacheResponse));
            if (ApacheUtils.isRequestSuccessful(execOneRequestParams.apacheResponse)) {
                return this.handleSuccessResponse(execOneRequestParams, httpClientContext, n);
            }
            return this.handleServiceErrorResponse(execOneRequestParams, httpClientContext, n);
        }

        private boolean isSignerOverridden() {
            return AmazonHttpClient.this.config != null && AmazonHttpClient.this.config.getSignerOverride() != null;
        }

        private Response<Output> handleServiceErrorResponse(ExecOneRequestParams execOneRequestParams, HttpClientContext httpClientContext, int n) throws IOException, InterruptedException {
            if (AmazonHttpClient.isTemporaryRedirect(execOneRequestParams.apacheResponse)) {
                Header[] headerArray = execOneRequestParams.apacheResponse.getHeaders("location");
                String string = headerArray[0].getValue();
                if (log.isDebugEnabled()) {
                    log.debug("Redirecting to: " + string);
                }
                execOneRequestParams.redirectedURI = URI.create(string);
                this.awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)n).addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, null);
                return null;
            }
            execOneRequestParams.leaveHttpConnectionOpen = this.errorResponseHandler.needsConnectionLeftOpen();
            SdkBaseException sdkBaseException = this.handleErrorResponse(execOneRequestParams.apacheRequest, execOneRequestParams.apacheResponse, httpClientContext);
            ClockSkewAdjuster.ClockSkewAdjustment clockSkewAdjustment = AmazonHttpClient.this.clockSkewAdjuster.getAdjustment(new ClockSkewAdjuster.AdjustmentRequest().exception(sdkBaseException).clientRequest(this.request).serviceResponse(execOneRequestParams.apacheResponse));
            if (clockSkewAdjustment.shouldAdjustForSkew()) {
                AmazonHttpClient.this.timeOffset = clockSkewAdjustment.inSeconds();
                this.request.setTimeOffset(AmazonHttpClient.this.timeOffset);
                SDKGlobalTime.setGlobalTimeOffset(AmazonHttpClient.this.timeOffset);
            }
            if (RetryUtils.isThrottlingException(sdkBaseException)) {
                AmazonHttpClient.this.tokenBucket.updateClientSendingRate(true);
            }
            execOneRequestParams.authRetryParam = null;
            AuthErrorRetryStrategy authErrorRetryStrategy = this.executionContext.getAuthErrorRetryStrategy();
            if (authErrorRetryStrategy != null && sdkBaseException instanceof AmazonServiceException) {
                HttpResponse httpResponse = ApacheUtils.createResponse(this.request, execOneRequestParams.apacheRequest, execOneRequestParams.apacheResponse, httpClientContext);
                execOneRequestParams.authRetryParam = authErrorRetryStrategy.shouldRetryWithAuthParam(this.request, httpResponse, (AmazonServiceException)sdkBaseException);
            }
            if (execOneRequestParams.authRetryParam == null && !this.shouldRetry(execOneRequestParams, sdkBaseException)) {
                throw sdkBaseException;
            }
            if (RetryUtils.isThrottlingException(sdkBaseException)) {
                this.awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)sdkBaseException);
            }
            execOneRequestParams.retriedException = sdkBaseException;
            return null;
        }

        private Response<Output> handleSuccessResponse(ExecOneRequestParams execOneRequestParams, HttpClientContext httpClientContext, int n) throws IOException, InterruptedException {
            this.awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)n);
            execOneRequestParams.leaveHttpConnectionOpen = this.responseHandler.needsConnectionLeftOpen();
            HttpResponse httpResponse = ApacheUtils.createResponse(this.request, execOneRequestParams.apacheRequest, execOneRequestParams.apacheResponse, httpClientContext);
            Output Output2 = this.handleResponse(httpResponse);
            if (execOneRequestParams.isRetry() && this.executionContext.retryCapacityConsumed()) {
                AmazonHttpClient.this.retryCapacity.release(execOneRequestParams.lastConsumedRetryCapacity);
            } else {
                AmazonHttpClient.this.retryCapacity.release();
            }
            AmazonHttpClient.this.tokenBucket.updateClientSendingRate(false);
            return new Response<Output>(Output2, httpResponse);
        }

        private void resetRequestInputStream(Request<?> request, SdkBaseException sdkBaseException) throws ResetException {
            InputStream inputStream2 = request.getContent();
            if (inputStream2 != null && inputStream2.markSupported()) {
                try {
                    inputStream2.reset();
                }
                catch (IOException iOException) {
                    ResetException resetException = new ResetException("The request to the service failed with a retryable reason, but resetting the request input stream has failed. See exception.getExtraInfo or debug-level logging for the original failure that caused this retry.", iOException);
                    resetException.setExtraInfo(sdkBaseException.getMessage());
                    throw resetException;
                }
            }
        }

        private boolean shouldBufferHttpEntity(boolean bl, ExecutionContext executionContext, ExecOneRequestParams execOneRequestParams, HttpRequestAbortTaskTracker httpRequestAbortTaskTracker) {
            return (executionContext.getClientExecutionTrackerTask().isEnabled() || httpRequestAbortTaskTracker.isEnabled()) && !bl && execOneRequestParams.apacheResponse.getEntity() != null;
        }

        private void captureConnectionPoolMetrics() {
            if (this.awsRequestMetrics.isEnabled() && AmazonHttpClient.this.httpClient.getHttpClientConnectionManager() instanceof ConnPoolControl) {
                PoolStats poolStats = ((ConnPoolControl)((Object)AmazonHttpClient.this.httpClient.getHttpClientConnectionManager())).getTotalStats();
                this.awsRequestMetrics.withCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount, (long)poolStats.getAvailable()).withCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount, (long)poolStats.getLeased()).withCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount, (long)poolStats.getPending());
            }
        }

        private <T extends Throwable> T captureExceptionMetrics(T t2) {
            AmazonServiceException amazonServiceException;
            this.awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.Exception).addProperty(AWSRequestMetrics.Field.Exception, t2);
            if (t2 instanceof AmazonServiceException && RetryUtils.isThrottlingException(amazonServiceException = (AmazonServiceException)t2)) {
                this.awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)amazonServiceException);
            }
            return t2;
        }

        private void setSdkTransactionId(Request<?> request) {
            request.addHeader(AmazonHttpClient.HEADER_SDK_TRANSACTION_ID, new UUID(AmazonHttpClient.this.random.nextLong(), AmazonHttpClient.this.random.nextLong()).toString());
        }

        private void setUserAgent(Request<?> request) {
            RequestClientOptions requestClientOptions = this.requestConfig.getRequestClientOptions();
            if (requestClientOptions != null) {
                request.addHeader(AmazonHttpClient.HEADER_USER_AGENT, RuntimeHttpUtils.getUserAgent(AmazonHttpClient.this.config, requestClientOptions.getClientMarker(RequestClientOptions.Marker.USER_AGENT)));
            } else {
                request.addHeader(AmazonHttpClient.HEADER_USER_AGENT, RuntimeHttpUtils.getUserAgent(AmazonHttpClient.this.config, null));
            }
        }

        private void setTraceId(Request<?> request) {
            String string;
            String string2 = request.getHeaders().get(AmazonHttpClient.TRACE_ID_HEADER);
            if (StringUtils.isNullOrEmpty(string2) && !StringUtils.isNullOrEmpty(string = RuntimeHttpUtils.getLambdaEnvironmentTraceId())) {
                request.addHeader(AmazonHttpClient.TRACE_ID_HEADER, string);
            }
        }

        private void updateRetryHeaderInfo(Request<?> request, ExecOneRequestParams execOneRequestParams) {
            int n = AmazonHttpClient.this.retryCapacity.availableCapacity();
            String string = String.format("%s/%s/%s", execOneRequestParams.requestCount - 1, execOneRequestParams.lastBackoffDelay, n >= 0 ? Integer.valueOf(n) : "");
            request.addHeader(AmazonHttpClient.HEADER_SDK_RETRY_INFO, string);
        }

        private boolean shouldRetry(ExecOneRequestParams execOneRequestParams, SdkBaseException sdkBaseException) {
            Object object;
            int n = execOneRequestParams.requestCount - 1;
            HttpRequestBase httpRequestBase = execOneRequestParams.apacheRequest;
            if (httpRequestBase instanceof HttpEntityEnclosingRequest && (object = ((HttpEntityEnclosingRequest)((Object)httpRequestBase)).getEntity()) != null && !object.isRepeatable()) {
                if (log.isDebugEnabled()) {
                    log.debug("Entity not repeatable");
                }
                return false;
            }
            object = RetryPolicyContext.builder().request(this.request).originalRequest(this.requestConfig.getOriginalRequest()).exception(sdkBaseException).retriesAttempted(n).httpStatusCode(execOneRequestParams.getStatusCode()).build();
            if (!this.acquireRetryCapacity((RetryPolicyContext)object, execOneRequestParams)) {
                return false;
            }
            if (!AmazonHttpClient.this.retryPolicy.shouldRetry((RetryPolicyContext)object)) {
                if (this.executionContext.retryCapacityConsumed()) {
                    AmazonHttpClient.this.retryCapacity.release(5);
                }
                this.reportMaxRetriesExceededIfRetryable((RetryPolicyContext)object);
                return false;
            }
            return true;
        }

        private void getSendToken() {
            if (AmazonHttpClient.this.retryMode != RetryMode.ADAPTIVE) {
                return;
            }
            if (!AmazonHttpClient.this.tokenBucket.acquire(1.0, this.fastFailRateLimiting())) {
                throw new SdkClientException("Unable to acquire enough send tokens to execute request.");
            }
        }

        private boolean fastFailRateLimiting() {
            return AmazonHttpClient.this.config.getRetryPolicy().isFastFailRateLimiting();
        }

        private boolean acquireRetryCapacity(RetryPolicyContext retryPolicyContext, ExecOneRequestParams execOneRequestParams) {
            switch (AmazonHttpClient.this.retryMode) {
                case LEGACY: {
                    return this.legacyAcquireRetryCapacity(retryPolicyContext, execOneRequestParams);
                }
                case ADAPTIVE: 
                case STANDARD: {
                    return this.standardAcquireRetryCapacity(retryPolicyContext, execOneRequestParams);
                }
            }
            throw new IllegalStateException("Unsupported retry mode: " + (Object)((Object)AmazonHttpClient.this.retryMode));
        }

        private boolean standardAcquireRetryCapacity(RetryPolicyContext retryPolicyContext, ExecOneRequestParams execOneRequestParams) {
            SdkBaseException sdkBaseException = retryPolicyContext.exception();
            if (this.isTimeoutError(sdkBaseException)) {
                return this.doAcquireCapacity(retryPolicyContext, 10, execOneRequestParams);
            }
            return this.doAcquireCapacity(retryPolicyContext, 5, execOneRequestParams);
        }

        private boolean isTimeoutError(SdkBaseException sdkBaseException) {
            Throwable throwable = sdkBaseException.getCause();
            return throwable instanceof ConnectTimeoutException || throwable instanceof SocketTimeoutException;
        }

        private boolean legacyAcquireRetryCapacity(RetryPolicyContext retryPolicyContext, ExecOneRequestParams execOneRequestParams) {
            if (!RetryUtils.isThrottlingException(retryPolicyContext.exception())) {
                return this.doAcquireCapacity(retryPolicyContext, 5, execOneRequestParams);
            }
            return true;
        }

        private boolean doAcquireCapacity(RetryPolicyContext retryPolicyContext, int n, ExecOneRequestParams execOneRequestParams) {
            if (!AmazonHttpClient.this.retryCapacity.acquire(n)) {
                this.awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.ThrottledRetryCount);
                this.reportMaxRetriesExceededIfRetryable(retryPolicyContext);
                return false;
            }
            execOneRequestParams.lastConsumedRetryCapacity = n;
            this.executionContext.markRetryCapacityConsumed();
            return true;
        }

        private void reportMaxRetriesExceededIfRetryable(RetryPolicyContext retryPolicyContext) {
            if (AmazonHttpClient.this.retryPolicy instanceof RetryPolicyAdapter && ((RetryPolicyAdapter)AmazonHttpClient.this.retryPolicy).isRetryable(retryPolicyContext)) {
                this.awsRequestMetrics.addPropertyWith(AwsClientSideMonitoringMetrics.MaxRetriesExceeded, (Object)true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Output handleResponse(HttpResponse httpResponse) throws IOException, InterruptedException {
            ProgressListener progressListener = this.requestConfig.getProgressListener();
            try {
                Output Output2;
                Map<String, String> map;
                String string;
                CountingInputStream countingInputStream = null;
                InputStream inputStream2 = httpResponse.getContent();
                if (inputStream2 != null) {
                    if (System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null) {
                        countingInputStream = new CountingInputStream(inputStream2);
                        inputStream2 = countingInputStream;
                        httpResponse.setContent(inputStream2);
                    }
                    httpResponse.setContent(ProgressInputStream.inputStreamForResponse(inputStream2, progressListener));
                }
                if ((string = (map = httpResponse.getHeaders()).get("Content-Length")) != null) {
                    try {
                        long l = Long.parseLong(string);
                        SDKProgressPublisher.publishResponseContentLength(progressListener, l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warn("Cannot parse the Content-Length header of the response.");
                    }
                }
                this.awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.HTTP_RESPONSE_STARTED_EVENT);
                try {
                    Output2 = this.responseHandler.handle(this.beforeUnmarshalling(httpResponse));
                }
                finally {
                    this.awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
                }
                SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.HTTP_RESPONSE_COMPLETED_EVENT);
                if (countingInputStream != null) {
                    this.awsRequestMetrics.setCounter(AWSRequestMetrics.Field.BytesProcessed, countingInputStream.getByteCount());
                }
                return Output2;
            }
            catch (CRC32MismatchException cRC32MismatchException) {
                throw cRC32MismatchException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (AmazonClientException amazonClientException) {
                throw amazonClientException;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception exception) {
                String string = "Unable to unmarshall response (" + exception.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
                throw new SdkClientException(string, exception);
            }
        }

        private HttpResponse beforeUnmarshalling(HttpResponse httpResponse) {
            HttpResponse httpResponse2 = httpResponse;
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                httpResponse2 = requestHandler2.beforeUnmarshalling(this.request, httpResponse2);
            }
            return httpResponse2;
        }

        private SdkBaseException handleErrorResponse(HttpRequestBase httpRequestBase, org.apache.http.HttpResponse httpResponse, HttpContext httpContext) throws IOException, InterruptedException {
            SdkBaseException sdkBaseException;
            String string;
            int n;
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine == null) {
                n = -1;
                string = null;
            } else {
                n = statusLine.getStatusCode();
                string = statusLine.getReasonPhrase();
            }
            HttpResponse httpResponse2 = ApacheUtils.createResponse(this.request, httpRequestBase, httpResponse, httpContext);
            try {
                sdkBaseException = this.errorResponseHandler.handle(httpResponse2);
                if (requestLog.isDebugEnabled()) {
                    requestLog.debug("Received error response: " + sdkBaseException);
                }
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception exception) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                String string2 = "Unable to unmarshall error response (" + exception.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(n)) + ", Response Text: " + string;
                throw new SdkClientException(string2, exception);
            }
            sdkBaseException.fillInStackTrace();
            return sdkBaseException;
        }

        private void pauseBeforeRetry(ExecOneRequestParams execOneRequestParams, ProgressListener progressListener) throws InterruptedException {
            SDKProgressPublisher.publishProgress(progressListener, ProgressEventType.CLIENT_REQUEST_RETRY_EVENT);
            this.awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
            try {
                this.doPauseBeforeRetry(execOneRequestParams);
            }
            finally {
                this.awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
            }
        }

        private void doPauseBeforeRetry(ExecOneRequestParams execOneRequestParams) throws InterruptedException {
            int n = execOneRequestParams.requestCount - 2;
            RetryPolicyContext retryPolicyContext = RetryPolicyContext.builder().request(this.request).originalRequest(this.requestConfig.getOriginalRequest()).retriesAttempted(n).exception(execOneRequestParams.retriedException).build();
            if (retryPolicyContext.exception() != null) {
                long l;
                execOneRequestParams.lastBackoffDelay = l = AmazonHttpClient.this.retryPolicy.computeDelayBeforeNextRetry(retryPolicyContext);
                if (log.isDebugEnabled()) {
                    log.debug("Retriable error detected, will retry in " + l + "ms, attempt number: " + n);
                }
                Thread.sleep(l);
            }
        }

        private int getRequestTimeout(RequestConfig requestConfig) {
            if (requestConfig.getRequestTimeout() != null) {
                return requestConfig.getRequestTimeout();
            }
            return AmazonHttpClient.this.config.getRequestTimeout();
        }

        private int getClientExecutionTimeout(RequestConfig requestConfig) {
            if (requestConfig.getClientExecutionTimeout() != null) {
                return requestConfig.getClientExecutionTimeout();
            }
            return AmazonHttpClient.this.config.getClientExecutionTimeout();
        }

        private class ExecOneRequestParams {
            int requestCount;
            long lastBackoffDelay = 0L;
            SdkBaseException retriedException;
            HttpRequestBase apacheRequest;
            org.apache.http.HttpResponse apacheResponse;
            URI redirectedURI;
            AuthRetryParameters authRetryParam;
            int lastConsumedRetryCapacity;
            boolean leaveHttpConnectionOpen;
            private Signer signer;
            private URI signerURI;

            private ExecOneRequestParams() {
            }

            boolean isRetry() {
                return this.requestCount > 1 || this.redirectedURI != null || this.authRetryParam != null;
            }

            void initPerRetry() {
                ++this.requestCount;
                this.apacheRequest = null;
                this.apacheResponse = null;
                this.leaveHttpConnectionOpen = false;
            }

            void newSigner(Request<?> request, ExecutionContext executionContext) {
                SignerProviderContext.Builder builder = SignerProviderContext.builder().withRequest(request).withRequestConfig(RequestExecutor.this.requestConfig);
                if (this.authRetryParam != null) {
                    this.signerURI = this.authRetryParam.getEndpointForRetry();
                    this.signer = this.authRetryParam.getSignerForRetry();
                    executionContext.setSigner(this.signer);
                } else if (this.redirectedURI != null && !this.redirectedURI.equals(this.signerURI)) {
                    String string;
                    this.signerURI = this.redirectedURI;
                    this.signer = executionContext.getSigner(builder.withUri(this.signerURI).withIsRedirect(true).build());
                    if (this.signer instanceof AWS4Signer && (string = ((AWS4Signer)this.signer).getRegionName()) != null) {
                        request.addHandlerContext(HandlerContextKey.SIGNING_REGION, string);
                    }
                } else if (this.signer == null) {
                    this.signerURI = request.getEndpoint();
                    this.signer = executionContext.getSigner(builder.withUri(this.signerURI).build());
                }
            }

            HttpRequestBase newApacheRequest(HttpRequestFactory<HttpRequestBase> httpRequestFactory, Request<?> request, HttpClientSettings httpClientSettings) throws IOException {
                this.apacheRequest = httpRequestFactory.create(request, httpClientSettings);
                if (this.redirectedURI != null) {
                    this.apacheRequest.setURI(this.redirectedURI);
                }
                return this.apacheRequest;
            }

            void resetBeforeHttpRequest() {
                this.retriedException = null;
                this.authRetryParam = null;
                this.redirectedURI = null;
            }

            private Integer getStatusCode() {
                if (this.apacheResponse == null || this.apacheResponse.getStatusLine() == null) {
                    return null;
                }
                return this.apacheResponse.getStatusLine().getStatusCode();
            }
        }
    }

    private class RequestExecutionBuilderImpl
    implements RequestExecutionBuilder {
        private Request<?> request;
        private RequestConfig requestConfig;
        private HttpResponseHandler<? extends SdkBaseException> errorResponseHandler;
        private ExecutionContext executionContext = new ExecutionContext();

        private RequestExecutionBuilderImpl() {
        }

        @Override
        public RequestExecutionBuilder request(Request<?> request) {
            this.request = request;
            return this;
        }

        @Override
        public RequestExecutionBuilder errorResponseHandler(HttpResponseHandler<? extends SdkBaseException> httpResponseHandler) {
            this.errorResponseHandler = httpResponseHandler;
            return this;
        }

        @Override
        public RequestExecutionBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Override
        public RequestExecutionBuilder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        @Override
        public <Output> Response<Output> execute(HttpResponseHandler<Output> httpResponseHandler) {
            RequestConfig requestConfig = this.requestConfig != null ? this.requestConfig : new AmazonWebServiceRequestAdapter(this.request.getOriginalRequest());
            return new RequestExecutor(this.request, requestConfig, AmazonHttpClient.this.getNonNullResponseHandler(this.errorResponseHandler), AmazonHttpClient.this.getNonNullResponseHandler(httpResponseHandler), this.executionContext, this.getRequestHandlers()).execute();
        }

        @Override
        public Response<Void> execute() {
            return this.execute(null);
        }

        private List<RequestHandler2> getRequestHandlers() {
            List<RequestHandler2> list = this.executionContext.getRequestHandler2s();
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }

    public static interface RequestExecutionBuilder {
        public RequestExecutionBuilder request(Request<?> var1);

        public RequestExecutionBuilder errorResponseHandler(HttpResponseHandler<? extends SdkBaseException> var1);

        public RequestExecutionBuilder executionContext(ExecutionContext var1);

        public RequestExecutionBuilder requestConfig(RequestConfig var1);

        public <Output> Response<Output> execute(HttpResponseHandler<Output> var1);

        public Response<Void> execute();
    }

    public static class Builder {
        private ClientConfiguration clientConfig;
        private RetryPolicy retryPolicy;
        private RequestMetricCollector requestMetricCollector;
        private boolean useBrowserCompatibleHostNameVerifier;
        private boolean calculateCRC32FromCompressedData;

        private Builder() {
        }

        public Builder clientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfig = clientConfiguration;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder requestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = requestMetricCollector;
            return this;
        }

        public Builder useBrowserCompatibleHostNameVerifier(boolean bl) {
            this.useBrowserCompatibleHostNameVerifier = bl;
            return this;
        }

        public Builder calculateCRC32FromCompressedData(boolean bl) {
            this.calculateCRC32FromCompressedData = bl;
            return this;
        }

        public AmazonHttpClient build() {
            return new AmazonHttpClient(this.clientConfig, this.retryPolicy, this.requestMetricCollector, this.useBrowserCompatibleHostNameVerifier, this.calculateCRC32FromCompressedData);
        }
    }
}

