/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.DeliveryMode;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.LogFactory;

public class SDKProgressPublisher {
    private static volatile Future<?> latestFutureTask;

    public static Future<?> publishProgress(ProgressListener progressListener, ProgressEventType progressEventType) {
        if (progressListener == ProgressListener.NOOP || progressListener == null || progressEventType == null) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(progressListener, new ProgressEvent(progressEventType));
    }

    private static Future<?> deliverEvent(final ProgressListener progressListener, final ProgressEvent progressEvent) {
        DeliveryMode deliveryMode;
        if (progressListener instanceof DeliveryMode && (deliveryMode = (DeliveryMode)((Object)progressListener)).isSyncCallSafe()) {
            return SDKProgressPublisher.quietlyCallListener(progressListener, progressEvent);
        }
        latestFutureTask = LazyHolder.executor.submit(new Runnable(){

            @Override
            public void run() {
                progressListener.progressChanged(progressEvent);
            }
        });
        return latestFutureTask;
    }

    private static Future<?> quietlyCallListener(ProgressListener progressListener, ProgressEvent progressEvent) {
        try {
            progressListener.progressChanged(progressEvent);
        }
        catch (Throwable throwable) {
            LogFactory.getLog(SDKProgressPublisher.class).debug("Failure from the event listener", throwable);
        }
        return null;
    }

    public static Future<?> publishRequestContentLength(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishByteCountEvent(progressListener, ProgressEventType.REQUEST_CONTENT_LENGTH_EVENT, l);
    }

    public static Future<?> publishResponseContentLength(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishByteCountEvent(progressListener, ProgressEventType.RESPONSE_CONTENT_LENGTH_EVENT, l);
    }

    public static Future<?> publishRequestBytesTransferred(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishByteCountEvent(progressListener, ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT, l);
    }

    public static Future<?> publishResponseBytesTransferred(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishByteCountEvent(progressListener, ProgressEventType.RESPONSE_BYTE_TRANSFER_EVENT, l);
    }

    private static Future<?> publishByteCountEvent(ProgressListener progressListener, ProgressEventType progressEventType, long l) {
        if (progressListener == ProgressListener.NOOP || progressListener == null || l <= 0L) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(progressListener, new ProgressEvent(progressEventType, l));
    }

    public static Future<?> publishRequestReset(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishResetEvent(progressListener, ProgressEventType.HTTP_REQUEST_CONTENT_RESET_EVENT, l);
    }

    public static Future<?> publishResponseReset(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishResetEvent(progressListener, ProgressEventType.HTTP_RESPONSE_CONTENT_RESET_EVENT, l);
    }

    public static Future<?> publishResponseBytesDiscarded(ProgressListener progressListener, long l) {
        return SDKProgressPublisher.publishResetEvent(progressListener, ProgressEventType.RESPONSE_BYTE_DISCARD_EVENT, l);
    }

    private static Future<?> publishResetEvent(ProgressListener progressListener, ProgressEventType progressEventType, long l) {
        if (l <= 0L) {
            return null;
        }
        if (progressListener == ProgressListener.NOOP || progressListener == null) {
            return null;
        }
        return SDKProgressPublisher.deliverEvent(progressListener, new ProgressEvent(progressEventType, l));
    }

    protected static ExecutorService getExecutorService() {
        return LazyHolder.executor;
    }

    protected static Future<?> setLatestFutureTask(Future<?> future) {
        latestFutureTask = future;
        return latestFutureTask;
    }

    @Deprecated
    public static void waitTillCompletion() throws InterruptedException, ExecutionException {
        if (latestFutureTask != null) {
            latestFutureTask.get();
        }
    }

    public static void shutdown(boolean bl) {
        if (bl) {
            LazyHolder.executor.shutdownNow();
        } else {
            LazyHolder.executor.shutdown();
        }
    }

    private static final class LazyHolder {
        private static final ExecutorService executor = LazyHolder.createNewExecutorService();

        private LazyHolder() {
        }

        private static ExecutorService createNewExecutorService() {
            return Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable2) {
                    Thread thread2 = new Thread(runnable2);
                    thread2.setName("java-sdk-progress-listener-callback-thread");
                    thread2.setDaemon(true);
                    return thread2;
                }
            });
        }
    }
}

