/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.endpointdiscovery;

import com.amazonaws.endpointdiscovery.EndpointDiscoveryProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointDiscoveryProviderChain
implements EndpointDiscoveryProvider {
    private static final Log LOG = LogFactory.getLog(EndpointDiscoveryProviderChain.class);
    private final List<EndpointDiscoveryProvider> providers;

    public EndpointDiscoveryProviderChain(EndpointDiscoveryProvider ... endpointDiscoveryProviderArray) {
        this.providers = new ArrayList<EndpointDiscoveryProvider>(endpointDiscoveryProviderArray.length);
        Collections.addAll(this.providers, endpointDiscoveryProviderArray);
    }

    @Override
    public Boolean endpointDiscoveryEnabled() {
        Boolean bl = null;
        for (EndpointDiscoveryProvider endpointDiscoveryProvider : this.providers) {
            try {
                bl = endpointDiscoveryProvider.endpointDiscoveryEnabled();
                if (bl == null) continue;
                return bl;
            }
            catch (Exception exception) {
                LOG.debug("Unable to discover endpoint discovery setting " + endpointDiscoveryProvider.toString() + ": " + exception.getMessage());
            }
        }
        return bl;
    }
}

