/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.endpointdiscovery;

import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.profile.internal.AllProfiles;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryProvider;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import com.amazonaws.util.StringUtils;
import java.io.File;

public class AwsProfileEndpointDiscoveryProvider
implements EndpointDiscoveryProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileEndpointDiscoveryProvider() {
        this(AwsProfileNameLoader.INSTANCE.loadProfileName());
    }

    public AwsProfileEndpointDiscoveryProvider(String string) {
        this(string, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileEndpointDiscoveryProvider(String string, AwsProfileFileLocationProvider awsProfileFileLocationProvider, BasicProfileConfigLoader basicProfileConfigLoader) {
        this.profileName = string;
        this.locationProvider = awsProfileFileLocationProvider;
        this.profileConfigLoader = basicProfileConfigLoader;
    }

    @Override
    public Boolean endpointDiscoveryEnabled() {
        BasicProfile basicProfile;
        Boolean bl = null;
        File file = this.locationProvider.getLocation();
        if (file != null && file.exists() && (basicProfile = this.loadProfile(file)) != null && !StringUtils.isNullOrEmpty(basicProfile.getEndpointDiscovery())) {
            try {
                bl = Boolean.parseBoolean(basicProfile.getEndpointDiscovery());
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to parse value for aws_enable_endpoint_discovery");
            }
        }
        return bl;
    }

    private BasicProfile loadProfile(File file) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(file);
        return allProfiles.getProfile(this.profileName);
    }
}

