/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.client;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.RequestConfig;
import com.amazonaws.Response;
import com.amazonaws.SdkBaseException;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.ClientExecutionParams;
import com.amazonaws.client.ClientHandler;
import com.amazonaws.client.ClientHandlerParams;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.List;

@Immutable
@ThreadSafe
@SdkProtectedApi
public class ClientHandlerImpl
extends ClientHandler {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final SignerProvider signerProvider;
    private final URI endpoint;
    private final List<RequestHandler2> requestHandler2s;
    private final RequestMetricCollector clientLevelMetricCollector;
    private final AmazonHttpClient client;

    public ClientHandlerImpl(ClientHandlerParams clientHandlerParams) {
        this.signerProvider = clientHandlerParams.getClientParams().getSignerProvider();
        this.endpoint = clientHandlerParams.getClientParams().getEndpoint();
        this.awsCredentialsProvider = clientHandlerParams.getClientParams().getCredentialsProvider();
        this.requestHandler2s = clientHandlerParams.getClientParams().getRequestHandlers();
        this.clientLevelMetricCollector = clientHandlerParams.getClientParams().getRequestMetricCollector();
        this.client = this.buildHttpClient(clientHandlerParams);
    }

    private AmazonHttpClient buildHttpClient(ClientHandlerParams clientHandlerParams) {
        AwsSyncClientParams awsSyncClientParams = clientHandlerParams.getClientParams();
        return AmazonHttpClient.builder().clientConfiguration(awsSyncClientParams.getClientConfiguration()).retryPolicy(awsSyncClientParams.getRetryPolicy()).requestMetricCollector(awsSyncClientParams.getRequestMetricCollector()).useBrowserCompatibleHostNameVerifier(clientHandlerParams.isDisableStrictHostnameVerification()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Input, Output> Output execute(ClientExecutionParams<Input, Output> clientExecutionParams) {
        Input Input2 = clientExecutionParams.getInput();
        ExecutionContext executionContext = this.createExecutionContext(clientExecutionParams.getRequestConfig());
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<Input> request = null;
        Response<Output> response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = clientExecutionParams.getMarshaller().marshall(Input2);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            response = this.invoke(request, clientExecutionParams.getRequestConfig(), executionContext, clientExecutionParams.getResponseHandler(), clientExecutionParams.getErrorResponseHandler());
            Output Output2 = response.getAwsResponse();
            return Output2;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, clientExecutionParams.getRequestConfig(), request, response);
        }
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }

    private ExecutionContext createExecutionContext(RequestConfig requestConfig) {
        boolean bl = this.isRequestMetricsEnabled(requestConfig);
        return ExecutionContext.builder().withRequestHandler2s(this.requestHandler2s).withUseRequestMetrics(bl).withSignerProvider(this.signerProvider).build();
    }

    private boolean isRequestMetricsEnabled(RequestConfig requestConfig) {
        return this.hasRequestMetricsCollector(requestConfig) || this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean hasRequestMetricsCollector(RequestConfig requestConfig) {
        return requestConfig.getRequestMetricsCollector() != null && requestConfig.getRequestMetricsCollector().isEnabled();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector requestMetricCollector = this.requestMetricCollector();
        return requestMetricCollector != null && requestMetricCollector.isEnabled();
    }

    private RequestMetricCollector requestMetricCollector() {
        return this.clientLevelMetricCollector != null ? this.clientLevelMetricCollector : AwsSdkMetrics.getRequestMetricCollector();
    }

    protected final <T extends AmazonWebServiceRequest> T beforeMarshalling(T t2) {
        Object object = t2;
        for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
            object = requestHandler2.beforeMarshalling((AmazonWebServiceRequest)object);
        }
        return object;
    }

    private <Output, Input> Response<Output> invoke(Request<Input> request, RequestConfig requestConfig, ExecutionContext executionContext, HttpResponseHandler<Output> httpResponseHandler, HttpResponseHandler<? extends SdkBaseException> httpResponseHandler2) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(requestConfig, this.awsCredentialsProvider));
        return this.doInvoke(request, requestConfig, executionContext, httpResponseHandler, httpResponseHandler2);
    }

    private <Output, Input> Response<Output> doInvoke(Request<Input> request, RequestConfig requestConfig, ExecutionContext executionContext, HttpResponseHandler<Output> httpResponseHandler, HttpResponseHandler<? extends SdkBaseException> httpResponseHandler2) {
        request.setEndpoint(this.endpoint);
        return this.client.requestExecutionBuilder().request(request).requestConfig(requestConfig).executionContext(executionContext).errorResponseHandler(httpResponseHandler2).execute(httpResponseHandler);
    }

    private void endClientExecution(AWSRequestMetrics aWSRequestMetrics, RequestConfig requestConfig, Request<?> request, Response<?> response) {
        if (request != null) {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            aWSRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector requestMetricCollector = this.findRequestMetricCollector(requestConfig);
            requestMetricCollector.collectMetrics(request, response);
            aWSRequestMetrics.log();
        }
    }

    private RequestMetricCollector findRequestMetricCollector(RequestConfig requestConfig) {
        RequestMetricCollector requestMetricCollector = requestConfig.getRequestMetricsCollector();
        if (requestMetricCollector != null) {
            return requestMetricCollector;
        }
        if (this.clientLevelMetricCollector != null) {
            return this.clientLevelMetricCollector;
        }
        return AwsSdkMetrics.getRequestMetricCollector();
    }
}

