/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Scanner;

public abstract class AbstractProfilesConfigFileScanner {
    protected abstract void onEmptyOrCommentLine(String var1, String var2);

    protected abstract void onProfileStartingLine(String var1, String var2);

    protected abstract void onProfileEndingLine(String var1);

    protected abstract void onEndOfFile();

    protected abstract void onProfileProperty(String var1, String var2, String var3, boolean var4, String var5);

    protected boolean isSupportedProperty(String string) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(Scanner scanner) {
        String string = null;
        try {
            int n = 0;
            while (scanner.hasNextLine()) {
                boolean bl;
                ++n;
                String string2 = scanner.nextLine().trim();
                if (string2.isEmpty() || string2.startsWith("#")) {
                    this.onEmptyOrCommentLine(string, string2);
                    continue;
                }
                String string3 = AbstractProfilesConfigFileScanner.parseProfileName(string2);
                boolean bl2 = bl = string3 != null;
                if (bl) {
                    if (string != null) {
                        this.onProfileEndingLine(string);
                    }
                    this.onProfileStartingLine(string3, string2);
                    string = string3;
                    continue;
                }
                Map.Entry<String, String> entry = AbstractProfilesConfigFileScanner.parsePropertyLine(string2, n);
                if (string == null) {
                    throw new IllegalArgumentException("Property is defined without a preceding profile name on line " + n);
                }
                this.onProfileProperty(string, entry.getKey(), entry.getValue(), this.isSupportedProperty(entry.getKey()), string2);
            }
            if (string != null) {
                this.onProfileEndingLine(string);
            }
            this.onEndOfFile();
        }
        finally {
            scanner.close();
        }
    }

    private static String parseProfileName(String string) {
        if (string.startsWith("[") && string.endsWith("]")) {
            String string2 = string.substring(1, string.length() - 1);
            return string2.trim();
        }
        return null;
    }

    private static Map.Entry<String, String> parsePropertyLine(String string, int n) {
        String[] stringArray = string.split("=", 2);
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Invalid property format: no '=' character is found on line " + n);
        }
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        return new AbstractMap.SimpleImmutableEntry<String, String>(string2, string3);
    }
}

