/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.presign;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.presign.PresignerParams;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.RuntimeHttpUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AWSCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(Request<?> request, Date date) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request).withUri(request.getEndpoint()).build()));
        if (request.getOriginalRequest() != null) {
            this.addCustomQueryParams(request);
            this.addCustomHeaders(request);
        }
        AWSCredentialsProvider aWSCredentialsProvider = this.resolveCredentials(request);
        presigner.presignRequest(request, aWSCredentialsProvider.getCredentials(), date);
        return RuntimeHttpUtils.convertRequestToUrl(request, true, false);
    }

    private void addCustomQueryParams(Request<?> request) {
        Map<String, List<String>> map = request.getOriginalRequest().getCustomQueryParameters();
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            request.addParameters(entry.getKey(), entry.getValue());
        }
    }

    private void addCustomHeaders(Request<?> request) {
        Map<String, String> map = request.getOriginalRequest().getCustomRequestHeaders();
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private AWSCredentialsProvider resolveCredentials(Request<?> request) {
        return CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.credentialsProvider);
    }

    public static class PresigningRequest
    extends AmazonWebServiceRequest {
        public PresigningRequest withRequestCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
            this.setRequestCredentialsProvider(aWSCredentialsProvider);
            return this;
        }
    }
}

