/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    @Override
    public AWSCredentials getCredentials() {
        String string = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String string2 = StringUtils.trim(System.getProperty("aws.secretKey"));
        String string3 = StringUtils.trim(System.getProperty("aws.sessionToken"));
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            throw new SdkClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        if (StringUtils.isNullOrEmpty(string3)) {
            return new BasicAWSCredentials(string, string2);
        }
        return new BasicSessionCredentials(string, string2, string3);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

