/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.SignatureVersion;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class QueryStringSigner
extends AbstractAWSSigner
implements Signer {
    private Date overriddenDate;

    @Override
    public void sign(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials) throws SdkClientException {
        this.sign(signableRequest, SignatureVersion.V2, SigningAlgorithm.HmacSHA256, aWSCredentials);
    }

    public void sign(SignableRequest<?> signableRequest, SignatureVersion signatureVersion, SigningAlgorithm signingAlgorithm, AWSCredentials aWSCredentials) throws SdkClientException {
        if (aWSCredentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        signableRequest.addParameter("AWSAccessKeyId", aWSCredentials2.getAWSAccessKeyId());
        signableRequest.addParameter("SignatureVersion", signatureVersion.toString());
        int n = signableRequest.getTimeOffset();
        signableRequest.addParameter("Timestamp", this.getFormattedTimestamp(n));
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(signableRequest, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = null;
        if (signatureVersion.equals((Object)SignatureVersion.V1)) {
            string = this.calculateStringToSignV1(signableRequest.getParameters());
        } else if (signatureVersion.equals((Object)SignatureVersion.V2)) {
            signableRequest.addParameter("SignatureMethod", signingAlgorithm.toString());
            string = this.calculateStringToSignV2(signableRequest);
        } else {
            throw new SdkClientException("Invalid Signature Version specified");
        }
        String string2 = this.signAndBase64Encode(string, aWSCredentials2.getAWSSecretKey(), signingAlgorithm);
        signableRequest.addParameter("Signature", string2);
    }

    private String calculateStringToSignV1(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(map);
        for (Map.Entry entry : treeMap.entrySet()) {
            for (String string : (List)entry.getValue()) {
                stringBuilder.append((String)entry.getKey()).append(string);
            }
        }
        return stringBuilder.toString();
    }

    private String calculateStringToSignV2(SignableRequest<?> signableRequest) throws SdkClientException {
        URI uRI = signableRequest.getEndpoint();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("POST").append("\n").append(this.getCanonicalizedEndpoint(uRI)).append("\n").append(this.getCanonicalizedResourcePath(signableRequest)).append("\n").append(this.getCanonicalizedQueryString(signableRequest.getParameters()));
        return stringBuilder.toString();
    }

    private String getCanonicalizedResourcePath(SignableRequest<?> signableRequest) {
        String string = "";
        if (signableRequest.getEndpoint().getPath() != null) {
            string = string + signableRequest.getEndpoint().getPath();
        }
        if (signableRequest.getResourcePath() != null) {
            if (string.length() > 0 && !string.endsWith("/") && !signableRequest.getResourcePath().startsWith("/")) {
                string = string + "/";
            }
            string = string + signableRequest.getResourcePath();
        } else if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private String getFormattedTimestamp(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return simpleDateFormat.format(this.overriddenDate);
        }
        return simpleDateFormat.format(this.getSignatureDate(n));
    }

    void overrideDate(Date date) {
        this.overriddenDate = date;
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> signableRequest, AWSSessionCredentials aWSSessionCredentials) {
        signableRequest.addParameter("SecurityToken", aWSSessionCredentials.getSessionToken());
    }
}

