/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.Platform;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.ValidationUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public final class ProcessCredentialsProvider
implements AWSCredentialsProvider {
    private final List<String> command;
    private final int expirationBufferValue;
    private final TimeUnit expirationBufferUnit;
    private final long processOutputLimit;
    private final Object credentialLock = new Object();
    private volatile AWSCredentials credentials = null;
    private volatile DateTime credentialExpirationTime = DateTime.now();

    private ProcessCredentialsProvider(Builder builder) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Platform.isWindows()) {
            arrayList.add("cmd.exe");
            arrayList.add("/C");
        } else {
            arrayList.add("sh");
            arrayList.add("-c");
        }
        String string = ValidationUtils.assertNotNull(builder.command, "command");
        arrayList.add(string);
        this.command = Collections.unmodifiableList(arrayList);
        this.processOutputLimit = ValidationUtils.assertNotNull(builder.processOutputLimit, "processOutputLimit");
        this.expirationBufferValue = ValidationUtils.assertNotNull(builder.expirationBufferValue, "expirationBufferValue");
        this.expirationBufferUnit = ValidationUtils.assertNotNull(builder.expirationBufferUnit, "expirationBufferUnit");
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        if (this.credentialsNeedUpdating()) {
            Object object = this.credentialLock;
            synchronized (object) {
                if (this.credentialsNeedUpdating()) {
                    this.refresh();
                }
            }
        }
        return this.credentials;
    }

    @Override
    public void refresh() {
        try {
            String string = this.executeCommand();
            JsonNode jsonNode = this.parseProcessOutput(string);
            AWSCredentials aWSCredentials = this.credentials(jsonNode);
            DateTime dateTime = this.credentialExpirationTime(jsonNode);
            this.credentials = aWSCredentials;
            this.credentialExpirationTime = dateTime;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Process-based credential refreshing has been interrupted.", interruptedException);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to refresh process-based credentials.", exception);
        }
    }

    public DateTime getCredentialExpirationTime() {
        return this.credentialExpirationTime;
    }

    private boolean credentialsNeedUpdating() {
        return this.credentials == null || this.credentialExpirationTime.isBeforeNow();
    }

    private JsonNode parseProcessOutput(String string) {
        JsonNode jsonNode = Jackson.fromSensitiveJsonString(string, JsonNode.class);
        if (!jsonNode.isObject()) {
            throw new IllegalStateException("Process did not return a JSON object.");
        }
        JsonNode jsonNode2 = jsonNode.get("Version");
        if (jsonNode2 == null || !jsonNode2.isInt() || jsonNode2.asInt() != 1) {
            throw new IllegalStateException("Unsupported credential version: " + jsonNode2);
        }
        return jsonNode;
    }

    private AWSCredentials credentials(JsonNode jsonNode) {
        String string = this.getText(jsonNode, "AccessKeyId");
        String string2 = this.getText(jsonNode, "SecretAccessKey");
        String string3 = this.getText(jsonNode, "SessionToken");
        ValidationUtils.assertStringNotEmpty(string, "AccessKeyId");
        ValidationUtils.assertStringNotEmpty(string2, "SecretAccessKey");
        if (string3 != null) {
            return new BasicSessionCredentials(string, string2, string3);
        }
        return new BasicAWSCredentials(string, string2);
    }

    private DateTime credentialExpirationTime(JsonNode jsonNode) {
        String string = this.getText(jsonNode, "Expiration");
        if (string != null) {
            DateTime dateTime = new DateTime(DateUtils.parseISO8601Date(string));
            dateTime = dateTime.minus(this.expirationBufferUnit.toMillis(this.expirationBufferValue));
            return dateTime;
        }
        return DateTime.now().plusYears(9999);
    }

    private String getText(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null) {
            return null;
        }
        if (!jsonNode2.isTextual()) {
            throw new IllegalStateException(string + " from credential process should be textual, but was " + (Object)((Object)jsonNode2.getNodeType()));
        }
        return jsonNode2.asText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeCommand() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = processBuilder.start();
        try {
            IOUtils.copy(process.getInputStream(), byteArrayOutputStream, this.processOutputLimit);
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new IllegalStateException("Command returned non-zero exit value: " + process.exitValue());
            }
            String string = new String(byteArrayOutputStream.toByteArray(), StringUtils.UTF8);
            return string;
        }
        finally {
            process.destroy();
        }
    }

    public static class Builder {
        private String command;
        private int expirationBufferValue = 15;
        private TimeUnit expirationBufferUnit = TimeUnit.SECONDS;
        private long processOutputLimit = 64000L;

        private Builder() {
        }

        private void setCommand(String string) {
            this.command = string;
        }

        public Builder withCommand(String string) {
            this.setCommand(string);
            return this;
        }

        public void setCredentialExpirationBuffer(int n, TimeUnit timeUnit) {
            this.expirationBufferValue = n;
            this.expirationBufferUnit = timeUnit;
        }

        public Builder withCredentialExpirationBuffer(int n, TimeUnit timeUnit) {
            this.setCredentialExpirationBuffer(n, timeUnit);
            return this;
        }

        private void setProcessOutputLimit(long l) {
            this.processOutputLimit = l;
        }

        public Builder withProcessOutputLimit(long l) {
            this.setProcessOutputLimit(l);
            return this;
        }

        public ProcessCredentialsProvider build() {
            return new ProcessCredentialsProvider(this);
        }
    }
}

