/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DecodedStreamBuffer {
    private static final Log log = LogFactory.getLog(DecodedStreamBuffer.class);
    private byte[] bufferArray;
    private int maxBufferSize;
    private int byteBuffered;
    private int pos = -1;
    private boolean bufferSizeOverflow;

    public DecodedStreamBuffer(int n) {
        this.bufferArray = new byte[n];
        this.maxBufferSize = n;
    }

    public void buffer(byte by) {
        this.pos = -1;
        if (this.byteBuffered >= this.maxBufferSize) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer size " + this.maxBufferSize + " has been exceeded and the input stream will not be repeatable. Freeing buffer memory");
            }
            this.bufferSizeOverflow = true;
        } else {
            this.bufferArray[this.byteBuffered++] = by;
        }
    }

    public void buffer(byte[] byArray, int n, int n2) {
        this.pos = -1;
        if (this.byteBuffered + n2 > this.maxBufferSize) {
            if (log.isDebugEnabled()) {
                log.debug("Buffer size " + this.maxBufferSize + " has been exceeded and the input stream will not be repeatable. Freeing buffer memory");
            }
            this.bufferSizeOverflow = true;
        } else {
            System.arraycopy(byArray, n, this.bufferArray, this.byteBuffered, n2);
            this.byteBuffered += n2;
        }
    }

    public boolean hasNext() {
        return this.pos != -1 && this.pos < this.byteBuffered;
    }

    public byte next() {
        return this.bufferArray[this.pos++];
    }

    public void startReadBuffer() {
        if (this.bufferSizeOverflow) {
            throw new SdkClientException("The input stream is not repeatable since the buffer size " + this.maxBufferSize + " has been exceeded.");
        }
        this.pos = 0;
    }
}

