/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ContainerCredentialsFetcher;
import com.amazonaws.auth.ContainerCredentialsRetryPolicy;
import com.amazonaws.internal.CredentialsEndpointProvider;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.CollectionUtils;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ContainerCredentialsProvider
implements AWSCredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String CONTAINER_CREDENTIALS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    static final String CONTAINER_AUTHORIZATION_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    private static final Set<String> ALLOWED_FULL_URI_HOSTS = ContainerCredentialsProvider.allowedHosts();
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    private final ContainerCredentialsFetcher credentialsFetcher;

    @Deprecated
    public ContainerCredentialsProvider() {
        this(new ECSCredentialsEndpointProvider());
    }

    public ContainerCredentialsProvider(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.credentialsFetcher = new ContainerCredentialsFetcher(credentialsEndpointProvider);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsFetcher.getCredentialsExpiration();
    }

    private static Set<String> allowedHosts() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("127.0.0.1");
        hashSet.add("localhost");
        return Collections.unmodifiableSet(hashSet);
    }

    static class FullUriCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        FullUriCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String string = System.getenv(ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI);
            if (string == null || string.length() == 0) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_FULL_URI is empty");
            }
            URI uRI = URI.create(string);
            if (!ALLOWED_FULL_URI_HOSTS.contains(uRI.getHost())) {
                throw new SdkClientException("The full URI (" + uRI + ") contained withing environment variable " + ContainerCredentialsProvider.CONTAINER_CREDENTIALS_FULL_URI + " has an invalid host. Host can only be one of [" + CollectionUtils.join(ALLOWED_FULL_URI_HOSTS, ", ") + "]");
            }
            return uRI;
        }

        @Override
        public Map<String, String> getHeaders() {
            if (System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN) != null) {
                return Collections.singletonMap("Authorization", System.getenv(ContainerCredentialsProvider.CONTAINER_AUTHORIZATION_TOKEN));
            }
            return new HashMap<String, String>();
        }
    }

    static class ECSCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        ECSCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() {
            String string = System.getenv(ContainerCredentialsProvider.ECS_CONTAINER_CREDENTIALS_PATH);
            if (string == null) {
                throw new SdkClientException("The environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI is empty");
            }
            return URI.create(ContainerCredentialsProvider.ECS_CREDENTIALS_ENDPOINT + string);
        }

        @Override
        public CredentialsEndpointRetryPolicy getRetryPolicy() {
            return ContainerCredentialsRetryPolicy.getInstance();
        }
    }
}

