/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

public class AWS3Signer
extends AbstractAWSSigner {
    private static final String AUTHORIZATION_HEADER = "X-Amzn-Authorization";
    private static final String NONCE_HEADER = "x-amz-nonce";
    private static final String HTTP_SCHEME = "AWS3";
    private static final String HTTPS_SCHEME = "AWS3-HTTPS";
    private String overriddenDate;
    @Deprecated
    protected static final DateUtils dateUtils = new DateUtils();
    private static final InternalLogApi log = InternalLogFactory.getLog(AWS3Signer.class);

    @Override
    public void sign(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials) throws SdkClientException {
        String string;
        byte[] byArray;
        String string2;
        if (aWSCredentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        SigningAlgorithm signingAlgorithm = SigningAlgorithm.HmacSHA256;
        String string3 = UUID.randomUUID().toString();
        int n = signableRequest.getTimeOffset();
        Date date = this.getSignatureDate(n);
        String string4 = DateUtils.formatRFC822Date(date);
        boolean bl = false;
        if (this.overriddenDate != null) {
            string4 = this.overriddenDate;
        }
        signableRequest.addHeader("Date", string4);
        signableRequest.addHeader("X-Amz-Date", string4);
        String string5 = signableRequest.getEndpoint().getHost();
        if (SdkHttpUtils.isUsingNonDefaultPort(signableRequest.getEndpoint())) {
            string5 = string5 + ":" + signableRequest.getEndpoint().getPort();
        }
        signableRequest.addHeader("Host", string5);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(signableRequest, (AWSSessionCredentials)aWSCredentials2);
        }
        if (bl) {
            signableRequest.addHeader(NONCE_HEADER, string3);
            string2 = string4 + string3;
            byArray = string2.getBytes(StringUtils.UTF8);
        } else {
            string = SdkHttpUtils.appendUri(signableRequest.getEndpoint().getPath(), signableRequest.getResourcePath());
            string2 = signableRequest.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(string) + "\n" + this.getCanonicalizedQueryString(signableRequest.getParameters()) + "\n" + this.getCanonicalizedHeadersForStringToSign(signableRequest) + "\n" + this.getRequestPayloadWithoutQueryParams(signableRequest);
            byArray = this.hash(string2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Calculated StringToSign: " + string2);
        }
        string = this.signAndBase64Encode(byArray, aWSCredentials2.getAWSSecretKey(), signingAlgorithm);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl ? HTTPS_SCHEME : HTTP_SCHEME).append(" ");
        stringBuilder.append("AWSAccessKeyId=" + aWSCredentials2.getAWSAccessKeyId() + ",");
        stringBuilder.append("Algorithm=" + signingAlgorithm.toString() + ",");
        if (!bl) {
            stringBuilder.append(this.getSignedHeadersComponent(signableRequest) + ",");
        }
        stringBuilder.append("Signature=" + string);
        signableRequest.addHeader(AUTHORIZATION_HEADER, stringBuilder.toString());
    }

    private String getSignedHeadersComponent(SignableRequest<?> signableRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SignedHeaders=");
        boolean bl = true;
        for (String string : this.getHeadersForStringToSign(signableRequest)) {
            if (!bl) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    protected List<String> getHeadersForStringToSign(SignableRequest<?> signableRequest) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : signableRequest.getHeaders().entrySet()) {
            String string = entry.getKey();
            String string2 = StringUtils.lowerCase(string);
            if (!string2.startsWith("x-amz") && !string2.equals("host")) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    void overrideDate(String string) {
        this.overriddenDate = string;
    }

    protected String getCanonicalizedHeadersForStringToSign(SignableRequest<?> signableRequest) {
        List<String> list = this.getHeadersForStringToSign(signableRequest);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, StringUtils.lowerCase(list.get(i)));
        }
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<String, String> entry : signableRequest.getHeaders().entrySet()) {
            if (!list.contains(StringUtils.lowerCase(entry.getKey()))) continue;
            treeMap.put(StringUtils.lowerCase((String)entry.getKey()), entry.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append(StringUtils.lowerCase((String)entry.getKey())).append(":").append((String)entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }

    protected boolean shouldUseHttpsScheme(SignableRequest<?> signableRequest) throws SdkClientException {
        try {
            String string = StringUtils.lowerCase(signableRequest.getEndpoint().toURL().getProtocol());
            if (string.equals("http")) {
                return false;
            }
            if (string.equals("https")) {
                return true;
            }
            throw new SdkClientException("Unknown request endpoint protocol encountered while signing request: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdkClientException("Unable to parse request endpoint during signing", malformedURLException);
        }
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> signableRequest, AWSSessionCredentials aWSSessionCredentials) {
        signableRequest.addHeader("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

