/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.SdkClientException;
import com.amazonaws.ServiceNameFactory;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EndpointPrefixAwareSigner;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.RegionFromEndpointResolverAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.internal.DefaultServiceEndpointBuilder;
import com.amazonaws.internal.auth.DefaultSignerProvider;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.log.CommonsLogFactory;
import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.monitoring.CsmConfiguration;
import com.amazonaws.monitoring.CsmConfigurationProvider;
import com.amazonaws.monitoring.DefaultCsmConfigurationProviderChain;
import com.amazonaws.monitoring.MonitoringListener;
import com.amazonaws.monitoring.internal.AgentMonitoringListener;
import com.amazonaws.monitoring.internal.ClientSideMonitoringRequestHandler;
import com.amazonaws.regions.EndpointToRegion;
import com.amazonaws.regions.MetadataSupportedRegionFromEndpointProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.Classes;
import com.amazonaws.util.RuntimeHttpUtils;
import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AmazonWebServiceClient {
    @Deprecated
    public static final boolean LOGGING_AWS_REQUEST_METRIC = true;
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    private static final String DEFAULT_CLIENT_ID = "";
    private static final Log log = LogFactory.getLog(AmazonWebServiceClient.class);
    private volatile boolean isImmutable = false;
    protected volatile URI endpoint;
    protected volatile boolean isEndpointOverridden = false;
    private volatile String signerRegionOverride;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler2> requestHandler2s;
    protected int timeOffset;
    private volatile SignerProvider signerProvider;
    private final CsmConfiguration csmConfiguration;
    private volatile String serviceName;
    private volatile String endpointPrefix;
    private volatile String signingRegion;
    private Collection<MonitoringListener> monitoringListeners;
    private AgentMonitoringListener agentMonitoringListener;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(clientConfiguration, requestMetricCollector, false);
    }

    @SdkProtectedApi
    protected AmazonWebServiceClient(final ClientConfiguration clientConfiguration, final RequestMetricCollector requestMetricCollector, boolean bl) {
        this(new AwsSyncClientParams(){

            @Override
            public AWSCredentialsProvider getCredentialsProvider() {
                return null;
            }

            @Override
            public ClientConfiguration getClientConfiguration() {
                return clientConfiguration;
            }

            @Override
            public RequestMetricCollector getRequestMetricCollector() {
                return requestMetricCollector;
            }

            @Override
            public List<RequestHandler2> getRequestHandlers() {
                return new CopyOnWriteArrayList<RequestHandler2>();
            }

            @Override
            public CsmConfigurationProvider getClientSideMonitoringConfigurationProvider() {
                return DefaultCsmConfigurationProviderChain.getInstance();
            }

            @Override
            public MonitoringListener getMonitoringListener() {
                return null;
            }
        }, !bl);
    }

    protected AmazonWebServiceClient(AwsSyncClientParams awsSyncClientParams) {
        this(awsSyncClientParams, null);
    }

    private AmazonWebServiceClient(AwsSyncClientParams awsSyncClientParams, Boolean bl) {
        this.clientConfiguration = awsSyncClientParams.getClientConfiguration();
        this.requestHandler2s = awsSyncClientParams.getRequestHandlers();
        this.monitoringListeners = new CopyOnWriteArrayList<MonitoringListener>();
        bl = bl != null ? bl.booleanValue() : this.useStrictHostNameVerification();
        this.client = new AmazonHttpClient(this.clientConfiguration, awsSyncClientParams.getRequestMetricCollector(), bl == false, this.calculateCRC32FromCompressedData());
        this.csmConfiguration = this.getCsmConfiguration(awsSyncClientParams.getClientSideMonitoringConfigurationProvider());
        if (this.isCsmEnabled()) {
            this.agentMonitoringListener = new AgentMonitoringListener(this.csmConfiguration.getHost(), this.csmConfiguration.getPort());
            this.monitoringListeners.add(this.agentMonitoringListener);
        }
        if (awsSyncClientParams.getMonitoringListener() != null) {
            this.monitoringListeners.add(awsSyncClientParams.getMonitoringListener());
        }
        if (this.shouldGenerateClientSideMonitoringEvents()) {
            this.requestHandler2s.add(new ClientSideMonitoringRequestHandler(this.getClientId(), this.monitoringListeners));
        }
    }

    @Deprecated
    protected Signer getSigner() {
        return this.signerProvider.getSigner(SignerProviderContext.builder().build());
    }

    @SdkProtectedApi
    protected boolean isEndpointOverridden() {
        return this.isEndpointOverridden;
    }

    @SdkProtectedApi
    protected SignerProvider getSignerProvider() {
        return this.signerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String string) throws IllegalArgumentException {
        this.checkMutability();
        URI uRI = this.toURI(string);
        Signer signer = this.computeSignerByURI(uRI, this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.isEndpointOverridden = true;
            this.endpoint = uRI;
            this.signerProvider = this.createSignerProvider(signer);
            this.signingRegion = EndpointToRegion.guessRegionNameForEndpoint(string, this.getEndpointPrefix());
        }
    }

    private URI toURI(String string) throws IllegalArgumentException {
        return RuntimeHttpUtils.toUri(string, this.clientConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String string, String string2, String string3) {
        URI uRI = this.toURI(string);
        Signer signer = this.computeSignerByServiceRegion(string2, string3, string3, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.setServiceNameIntern(string2);
            this.signerProvider = this.createSignerProvider(signer);
            this.isEndpointOverridden = true;
            this.endpoint = uRI;
            this.signerRegionOverride = string3;
            this.signingRegion = string3;
        }
    }

    public Signer getSignerByURI(URI uRI) {
        return this.computeSignerByURI(uRI, this.signerRegionOverride, true);
    }

    private Signer computeSignerByURI(URI uRI, String string, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("Endpoint is not set. Use setEndpoint to set an endpoint before performing any request.");
        }
        if (uRI.getHost() == null) {
            throw new IllegalArgumentException("Endpoint does not contain a valid host name: " + uRI);
        }
        String string2 = this.getServiceNameIntern();
        String string3 = EndpointToRegion.guessRegionNameForEndpointWithDefault(uRI.getHost(), this.getEndpointPrefix(), "us-east-1");
        return this.computeSignerByServiceRegion(string2, string3, string, bl);
    }

    private Signer computeSignerByServiceRegion(String string, String string2, String string3, boolean bl) {
        Signer signer;
        Signer signer2;
        String string4 = this.clientConfiguration.getSignerOverride();
        Signer signer3 = signer2 = string4 == null ? SignerFactory.getSigner(string, string2) : SignerFactory.getSignerByTypeAndService(string4, string);
        if (signer2 instanceof RegionAwareSigner) {
            signer = (RegionAwareSigner)signer2;
            if (string3 != null) {
                signer.setRegionName(string3);
            } else if (string2 != null && bl) {
                signer.setRegionName(string2);
            }
        }
        if (signer2 instanceof EndpointPrefixAwareSigner) {
            signer = (EndpointPrefixAwareSigner)signer2;
            signer.setEndpointPrefix(this.endpointPrefix);
        }
        if (signer2 instanceof RegionFromEndpointResolverAwareSigner) {
            signer = (RegionFromEndpointResolverAwareSigner)signer2;
            signer.setRegionFromEndpointResolver(new MetadataSupportedRegionFromEndpointProvider());
        }
        return signer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setRegion(Region region) throws IllegalArgumentException {
        this.checkMutability();
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String string = this.getEndpointPrefix();
        String string2 = this.getServiceNameIntern();
        URI uRI = new DefaultServiceEndpointBuilder(string, this.clientConfiguration.getProtocol().toString()).withRegion(region).getServiceEndpoint();
        Signer signer = this.computeSignerByServiceRegion(string2, region.getName(), this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.isEndpointOverridden = false;
            this.endpoint = uRI;
            this.signerProvider = this.createSignerProvider(signer);
            this.signingRegion = EndpointToRegion.guessRegionNameForEndpoint(this.endpoint.toString(), this.getEndpointPrefix());
        }
    }

    @Deprecated
    public final void configureRegion(Regions regions) {
        this.checkMutability();
        if (regions == null) {
            throw new IllegalArgumentException("No region provided");
        }
        this.setRegion(Region.getRegion(regions));
    }

    public void shutdown() {
        if (this.agentMonitoringListener != null) {
            this.agentMonitoringListener.shutdown();
        }
        this.client.shutdown();
    }

    @Deprecated
    public void addRequestHandler(RequestHandler requestHandler) {
        this.checkMutability();
        this.requestHandler2s.add(RequestHandler2.adapt(requestHandler));
    }

    @Deprecated
    public void addRequestHandler(RequestHandler2 requestHandler2) {
        this.checkMutability();
        this.requestHandler2s.add(requestHandler2);
    }

    @Deprecated
    public void removeRequestHandler(RequestHandler requestHandler) {
        this.checkMutability();
        this.requestHandler2s.remove(RequestHandler2.adapt(requestHandler));
    }

    @Deprecated
    public void removeRequestHandler(RequestHandler2 requestHandler2) {
        this.checkMutability();
        this.requestHandler2s.remove(requestHandler2);
    }

    protected final <T extends AmazonWebServiceRequest> T beforeMarshalling(T t2) {
        Object object = t2;
        for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
            object = requestHandler2.beforeMarshalling((AmazonWebServiceRequest)object);
        }
        return object;
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.createExecutionContext(amazonWebServiceRequest, this.signerProvider);
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest amazonWebServiceRequest, SignerProvider signerProvider) {
        boolean bl = this.isRequestMetricsEnabled(amazonWebServiceRequest) || AmazonWebServiceClient.isProfilingEnabled() || this.shouldGenerateClientSideMonitoringEvents();
        return ExecutionContext.builder().withRequestHandler2s(this.requestHandler2s).withUseRequestMetrics(bl).withAwsClient(this).withSignerProvider(signerProvider).build();
    }

    protected final ExecutionContext createExecutionContext(Request<?> request) {
        return this.createExecutionContext(request.getOriginalRequest());
    }

    protected SignerProvider createSignerProvider(Signer signer) {
        return new DefaultSignerProvider(this, signer);
    }

    protected static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    protected boolean shouldGenerateClientSideMonitoringEvents() {
        return !this.monitoringListeners.isEmpty();
    }

    protected final boolean isRequestMetricsEnabled(AmazonWebServiceRequest amazonWebServiceRequest) {
        RequestMetricCollector requestMetricCollector = amazonWebServiceRequest.getRequestMetricCollector();
        if (requestMetricCollector != null && requestMetricCollector.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector requestMetricCollector = this.requestMetricCollector();
        return requestMetricCollector != null && requestMetricCollector.isEnabled();
    }

    public void setTimeOffset(int n) {
        this.checkMutability();
        this.timeOffset = n;
    }

    public AmazonWebServiceClient withTimeOffset(int n) {
        this.checkMutability();
        this.setTimeOffset(n);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    public Collection<MonitoringListener> getMonitoringListeners() {
        return Collections.unmodifiableCollection(this.monitoringListeners);
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector requestMetricCollector = this.client.getRequestMetricCollector();
        return requestMetricCollector == null ? AwsSdkMetrics.getRequestMetricCollector() : requestMetricCollector;
    }

    private final RequestMetricCollector findRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        RequestMetricCollector requestMetricCollector2 = requestMetricCollector != null ? requestMetricCollector : (this.getRequestMetricsCollector() != null ? this.getRequestMetricsCollector() : AwsSdkMetrics.getRequestMetricCollector());
        return requestMetricCollector2;
    }

    protected final <T extends AmazonWebServiceRequest> T beforeClientExecution(T t2) {
        Object object = t2;
        for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
            object = requestHandler2.beforeExecution((AmazonWebServiceRequest)object);
        }
        return object;
    }

    protected final void endClientExecution(AWSRequestMetrics aWSRequestMetrics, Request<?> request, Response<?> response) {
        this.endClientExecution(aWSRequestMetrics, request, response, false);
    }

    protected final void endClientExecution(AWSRequestMetrics aWSRequestMetrics, Request<?> request, Response<?> response, @Deprecated boolean bl) {
        if (request != null) {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            aWSRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector requestMetricCollector = this.findRequestMetricCollector(request.getOriginalRequest().getRequestMetricCollector());
            requestMetricCollector.collectMetrics(request, response);
            aWSRequestMetrics.log();
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpointPrefix() {
        if (this.endpointPrefix != null) {
            return this.endpointPrefix;
        }
        String string = this.getHttpClientName();
        String string2 = ServiceNameFactory.getServiceNameInRegionMetadata(string);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            if (this.endpointPrefix != null) {
                return this.endpointPrefix;
            }
            if (string2 != null) {
                this.endpointPrefix = string2;
                return this.endpointPrefix;
            }
            this.endpointPrefix = this.getServiceNameIntern();
            return this.endpointPrefix;
        }
    }

    @SdkProtectedApi
    protected String getSigningRegion() {
        return this.signingRegion;
    }

    protected void setEndpointPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The parameter endpointPrefix must be specified!");
        }
        this.endpointPrefix = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The parameter serviceName must be specified!");
        }
        this.serviceName = string;
    }

    private String computeServiceName() {
        int n;
        String string = this.getHttpClientName();
        String string2 = ServiceNameFactory.getServiceName(string);
        if (string2 != null) {
            return string2;
        }
        int n2 = string.indexOf("JavaClient");
        if (n2 == -1 && (n2 = string.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + string);
        }
        int n3 = string.indexOf(AMAZON);
        if (n3 == -1) {
            n3 = string.indexOf(AWS);
            if (n3 == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + string);
            }
            n = AWS.length();
        } else {
            n = AMAZON.length();
        }
        if (n3 >= n2) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + string);
        }
        String string3 = string.substring(n3 + n, n2);
        return StringUtils.lowerCase(string3);
    }

    private String getHttpClientName() {
        Class<?> clazz = Classes.childClassOf(AmazonWebServiceClient.class, this);
        return clazz.getSimpleName();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String string) {
        this.checkMutability();
        Signer signer = this.computeSignerByURI(this.endpoint, string, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signerRegionOverride = string;
            this.signerProvider = this.createSignerProvider(signer);
            this.signingRegion = string;
        }
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withRegion(Region region) {
        this.setRegion(region);
        AmazonWebServiceClient amazonWebServiceClient = this;
        return (T)amazonWebServiceClient;
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withRegion(Regions regions) {
        this.configureRegion(regions);
        AmazonWebServiceClient amazonWebServiceClient = this;
        return (T)amazonWebServiceClient;
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withEndpoint(String string) {
        this.setEndpoint(string);
        AmazonWebServiceClient amazonWebServiceClient = this;
        return (T)amazonWebServiceClient;
    }

    @Deprecated
    @SdkInternalApi
    public final void makeImmutable() {
        this.isImmutable = true;
    }

    @SdkProtectedApi
    protected final void checkMutability() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Client is immutable when created with the builder.");
        }
    }

    protected boolean useStrictHostNameVerification() {
        return true;
    }

    protected boolean calculateCRC32FromCompressedData() {
        return false;
    }

    public String getSignerOverride() {
        return this.clientConfiguration.getSignerOverride();
    }

    public ClientConfiguration getClientConfiguration() {
        return new ClientConfiguration(this.clientConfiguration);
    }

    protected final boolean isCsmEnabled() {
        return this.csmConfiguration != null && this.csmConfiguration.isEnabled();
    }

    protected String getClientId() {
        if (this.csmConfiguration == null) {
            return DEFAULT_CLIENT_ID;
        }
        return this.csmConfiguration.getClientId();
    }

    private CsmConfiguration getCsmConfiguration(CsmConfigurationProvider csmConfigurationProvider) {
        try {
            return csmConfigurationProvider.getConfiguration();
        }
        catch (SdkClientException sdkClientException) {
            return null;
        }
    }

    static {
        boolean bl = InternalLogFactory.configureFactory(new CommonsLogFactory());
        if (log.isDebugEnabled()) {
            log.debug("Internal logging successfully configured to commons logger: " + bl);
        }
    }
}

