/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.system;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.ion.IonMutableCatalog;
import software.amazon.ion.SymbolTable;

public class SimpleCatalog
implements Iterable<SymbolTable>,
IonMutableCatalog {
    private Map<String, TreeMap<Integer, SymbolTable>> myTablesByName = new HashMap<String, TreeMap<Integer, SymbolTable>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolTable getTable(String string) {
        TreeMap<Integer, SymbolTable> treeMap;
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        Map<String, TreeMap<Integer, SymbolTable>> map = this.myTablesByName;
        synchronized (map) {
            treeMap = this.myTablesByName.get(string);
        }
        if (treeMap == null) {
            return null;
        }
        map = treeMap;
        synchronized (map) {
            Integer n = treeMap.lastKey();
            return treeMap.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolTable getTable(String string, int n) {
        TreeMap<Integer, SymbolTable> treeMap;
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        if (n < 1) {
            throw new IllegalArgumentException("version is < 1");
        }
        Map<String, TreeMap<Integer, SymbolTable>> map = this.myTablesByName;
        synchronized (map) {
            treeMap = this.myTablesByName.get(string);
        }
        if (treeMap == null) {
            return null;
        }
        map = treeMap;
        synchronized (map) {
            SymbolTable symbolTable = treeMap.get(n);
            if (symbolTable == null) {
                assert (!treeMap.isEmpty());
                Integer n2 = SimpleCatalog.bestMatch(n, treeMap.keySet());
                assert (n2 != null);
                symbolTable = treeMap.get(n2);
                assert (symbolTable != null);
            }
            return symbolTable;
        }
    }

    static Integer bestMatch(int n, Iterable<Integer> iterable) {
        int n2 = n;
        Integer n3 = null;
        for (Integer n4 : iterable) {
            assert (n4 != n);
            int n5 = n4;
            if (n < n2) {
                if (n >= n5 || n5 >= n2) continue;
                n2 = n5;
                n3 = n4;
                continue;
            }
            if (n2 < n) {
                if (n2 >= n5) continue;
                n2 = n5;
                n3 = n4;
                continue;
            }
            n2 = n5;
            n3 = n4;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putTable(SymbolTable symbolTable) {
        if (symbolTable.isLocalTable() || symbolTable.isSystemTable() || symbolTable.isSubstitute()) {
            throw new IllegalArgumentException("table cannot be local or system or substitute table");
        }
        String string = symbolTable.getName();
        int n = symbolTable.getVersion();
        assert (n >= 0);
        Map<String, TreeMap<Integer, SymbolTable>> map = this.myTablesByName;
        synchronized (map) {
            TreeMap<Integer, SymbolTable> treeMap = this.myTablesByName.get(string);
            if (treeMap == null) {
                treeMap = new TreeMap();
                this.myTablesByName.put(string, treeMap);
            }
            TreeMap<Integer, SymbolTable> treeMap2 = treeMap;
            synchronized (treeMap2) {
                treeMap.put(n, symbolTable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolTable removeTable(String string, int n) {
        SymbolTable symbolTable = null;
        Map<String, TreeMap<Integer, SymbolTable>> map = this.myTablesByName;
        synchronized (map) {
            TreeMap<Integer, SymbolTable> treeMap = this.myTablesByName.get(string);
            if (treeMap != null) {
                TreeMap<Integer, SymbolTable> treeMap2 = treeMap;
                synchronized (treeMap2) {
                    symbolTable = treeMap.remove(n);
                    if (treeMap.isEmpty()) {
                        this.myTablesByName.remove(string);
                    }
                }
            }
        }
        return symbolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SymbolTable> iterator() {
        ArrayList<SymbolTable> arrayList;
        Map<String, TreeMap<Integer, SymbolTable>> map = this.myTablesByName;
        synchronized (map) {
            arrayList = new ArrayList<SymbolTable>(this.myTablesByName.size());
            Collection<TreeMap<Integer, SymbolTable>> collection = this.myTablesByName.values();
            Iterator<TreeMap<Integer, SymbolTable>> iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                TreeMap<Integer, SymbolTable> treeMap;
                TreeMap<Integer, SymbolTable> treeMap2 = treeMap = iterator2.next();
                synchronized (treeMap2) {
                    arrayList.addAll(treeMap.values());
                }
            }
        }
        return arrayList.iterator();
    }
}

