/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.ListIterator;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonBlob;
import software.amazon.ion.IonBool;
import software.amazon.ion.IonClob;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonDecimal;
import software.amazon.ion.IonException;
import software.amazon.ion.IonFloat;
import software.amazon.ion.IonInt;
import software.amazon.ion.IonList;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonSexp;
import software.amazon.ion.IonString;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSymbol;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonValue;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.PrivateIonConstants;

class ReverseBinaryEncoder {
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int NULL_LENGTH_MASK = 15;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_BOOL = 16;
    private static final int TYPE_POS_INT = 32;
    private static final int TYPE_NEG_INT = 48;
    private static final int TYPE_FLOAT = 64;
    private static final int TYPE_DECIMAL = 80;
    private static final int TYPE_TIMESTAMP = 96;
    private static final int TYPE_SYMBOL = 112;
    private static final int TYPE_STRING = 128;
    private static final int TYPE_CLOB = 144;
    private static final int TYPE_BLOB = 160;
    private static final int TYPE_LIST = 176;
    private static final int TYPE_SEXP = 192;
    private static final int TYPE_STRUCT = 208;
    private static final int TYPE_ANNOTATIONS = 224;
    private byte[] myBuffer;
    private int myOffset;
    private SymbolTable mySymbolTable;
    private IonSystem myIonSystem;
    private static final byte[] negativeZeroBitArray = new byte[]{-128};
    private static final byte[] positiveZeroBitArray = new byte[0];

    ReverseBinaryEncoder(int n) {
        this.myBuffer = new byte[n];
        this.myOffset = n;
    }

    int byteSize() {
        return this.myBuffer.length - this.myOffset;
    }

    byte[] toNewByteArray() {
        int n = this.myBuffer.length - this.myOffset;
        byte[] byArray = new byte[n];
        System.arraycopy(this.myBuffer, this.myOffset, byArray, 0, n);
        return byArray;
    }

    int writeBytes(OutputStream outputStream2) throws IOException {
        int n = this.myBuffer.length - this.myOffset;
        byte[] byArray = new byte[n];
        System.arraycopy(this.myBuffer, this.myOffset, byArray, 0, n);
        outputStream2.write(byArray);
        return n;
    }

    void serialize(IonDatagram ionDatagram) throws IonException {
        this.myIonSystem = ionDatagram.getSystem();
        this.mySymbolTable = null;
        this.writeIonValue(ionDatagram);
        if (this.mySymbolTable != null && this.mySymbolTable.isLocalTable()) {
            this.writeLocalSymbolTable(this.mySymbolTable);
        }
        this.writeBytes(PrivateIonConstants.BINARY_VERSION_MARKER_1_0);
    }

    void serialize(SymbolTable symbolTable) throws IonException {
        this.writeLocalSymbolTable(symbolTable);
    }

    private int growBuffer(int n) {
        assert (n < 0);
        byte[] byArray = this.myBuffer;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[-n + n2 << 1];
        int n3 = byArray2.length - n2;
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        this.myBuffer = byArray2;
        this.myOffset += n3;
        return n + n3;
    }

    private void writeIonValue(IonValue ionValue) throws IonException {
        int n = this.myBuffer.length - this.myOffset;
        switch (ionValue.getType()) {
            case BLOB: {
                this.writeIonBlobContent((IonBlob)ionValue);
                break;
            }
            case BOOL: {
                this.writeIonBoolContent((IonBool)ionValue);
                break;
            }
            case CLOB: {
                this.writeIonClobContent((IonClob)ionValue);
                break;
            }
            case DECIMAL: {
                this.writeIonDecimalContent((IonDecimal)ionValue);
                break;
            }
            case FLOAT: {
                this.writeIonFloatContent((IonFloat)ionValue);
                break;
            }
            case INT: {
                this.writeIonIntContent((IonInt)ionValue);
                break;
            }
            case NULL: {
                this.writeIonNullContent();
                break;
            }
            case STRING: {
                this.writeIonStringContent((IonString)ionValue);
                break;
            }
            case SYMBOL: {
                this.writeIonSymbolContent((IonSymbol)ionValue);
                break;
            }
            case TIMESTAMP: {
                this.writeIonTimestampContent((IonTimestamp)ionValue);
                break;
            }
            case LIST: {
                this.writeIonListContent((IonList)ionValue);
                break;
            }
            case SEXP: {
                this.writeIonSexpContent((IonSexp)ionValue);
                break;
            }
            case STRUCT: {
                this.writeIonStructContent((IonStruct)ionValue);
                break;
            }
            case DATAGRAM: {
                this.writeIonDatagramContent((IonDatagram)ionValue);
                break;
            }
            default: {
                throw new IonException("IonType is unknown: " + (Object)((Object)ionValue.getType()));
            }
        }
        this.writeAnnotations(ionValue, n);
    }

    private void writeByte(int n) {
        int n2 = this.myOffset;
        if (--n2 < 0) {
            n2 = this.growBuffer(n2);
        }
        this.myBuffer[n2] = (byte)n;
        this.myOffset = n2;
    }

    private void writeBytes(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.myOffset;
        if ((n2 -= n) < 0) {
            n2 = this.growBuffer(n2);
        }
        System.arraycopy(byArray, 0, this.myBuffer, n2, n);
        this.myOffset = n2;
    }

    private void writeUInt(long l) {
        int n = this.myOffset;
        if (l < 256L) {
            if (--n < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)l;
        } else if (l < 65536L) {
            if ((n -= 2) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 8);
            this.myBuffer[n + 1] = (byte)l;
        } else if (l < 0x1000000L) {
            if ((n -= 3) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 16);
            this.myBuffer[n + 1] = (byte)(l >>> 8);
            this.myBuffer[n + 2] = (byte)l;
        } else if (l < 0x100000000L) {
            if ((n -= 4) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 24);
            this.myBuffer[n + 1] = (byte)(l >>> 16);
            this.myBuffer[n + 2] = (byte)(l >>> 8);
            this.myBuffer[n + 3] = (byte)l;
        } else if (l < 0x10000000000L) {
            if ((n -= 5) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 32);
            this.myBuffer[n + 1] = (byte)(l >>> 24);
            this.myBuffer[n + 2] = (byte)(l >>> 16);
            this.myBuffer[n + 3] = (byte)(l >>> 8);
            this.myBuffer[n + 4] = (byte)l;
        } else if (l < 0x1000000000000L) {
            if ((n -= 6) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 40);
            this.myBuffer[n + 1] = (byte)(l >>> 32);
            this.myBuffer[n + 2] = (byte)(l >>> 24);
            this.myBuffer[n + 3] = (byte)(l >>> 16);
            this.myBuffer[n + 4] = (byte)(l >>> 8);
            this.myBuffer[n + 5] = (byte)l;
        } else if (l < 0x100000000000000L) {
            if ((n -= 7) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 48);
            this.myBuffer[n + 1] = (byte)(l >>> 40);
            this.myBuffer[n + 2] = (byte)(l >>> 32);
            this.myBuffer[n + 3] = (byte)(l >>> 24);
            this.myBuffer[n + 4] = (byte)(l >>> 16);
            this.myBuffer[n + 5] = (byte)(l >>> 8);
            this.myBuffer[n + 6] = (byte)l;
        } else {
            if ((n -= 8) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 56);
            this.myBuffer[n + 1] = (byte)(l >>> 48);
            this.myBuffer[n + 2] = (byte)(l >>> 40);
            this.myBuffer[n + 3] = (byte)(l >>> 32);
            this.myBuffer[n + 4] = (byte)(l >>> 24);
            this.myBuffer[n + 5] = (byte)(l >>> 16);
            this.myBuffer[n + 6] = (byte)(l >>> 8);
            this.myBuffer[n + 7] = (byte)l;
        }
        this.myOffset = n;
    }

    private void writeVarUInt(int n) {
        int n2 = this.myOffset;
        if (n < 128) {
            if (--n2 < 0) {
                n2 = this.growBuffer(n2);
            }
            this.myBuffer[n2] = (byte)(n | 0x80);
        } else if (n < 16384) {
            if ((n2 -= 2) < 0) {
                n2 = this.growBuffer(n2);
            }
            this.myBuffer[n2] = (byte)(n >>> 7);
            this.myBuffer[n2 + 1] = (byte)(n | 0x80);
        } else if (n < 0x200000) {
            if ((n2 -= 3) < 0) {
                n2 = this.growBuffer(n2);
            }
            this.myBuffer[n2] = (byte)(n >>> 14);
            this.myBuffer[n2 + 1] = (byte)(n >>> 7 & 0x7F);
            this.myBuffer[n2 + 2] = (byte)(n | 0x80);
        } else if (n < 0x10000000) {
            if ((n2 -= 4) < 0) {
                n2 = this.growBuffer(n2);
            }
            this.myBuffer[n2] = (byte)(n >>> 21);
            this.myBuffer[n2 + 1] = (byte)(n >>> 14 & 0x7F);
            this.myBuffer[n2 + 2] = (byte)(n >>> 7 & 0x7F);
            this.myBuffer[n2 + 3] = (byte)(n | 0x80);
        } else {
            if ((n2 -= 5) < 0) {
                n2 = this.growBuffer(n2);
            }
            this.myBuffer[n2] = (byte)(n >>> 28);
            this.myBuffer[n2 + 1] = (byte)(n >>> 21 & 0x7F);
            this.myBuffer[n2 + 2] = (byte)(n >>> 14 & 0x7F);
            this.myBuffer[n2 + 3] = (byte)(n >>> 7 & 0x7F);
            this.myBuffer[n2 + 4] = (byte)(n | 0x80);
        }
        this.myOffset = n2;
    }

    private void writeVarInt(int n) {
        if (n == 0) {
            this.writeByte(128);
        } else {
            boolean bl;
            int n2 = this.myOffset;
            boolean bl2 = bl = n < 0;
            if (bl) {
                n = -n;
            }
            if (n < 64) {
                if (--n2 < 0) {
                    n2 = this.growBuffer(n2);
                }
                if (bl) {
                    n |= 0x40;
                }
                this.myBuffer[n2] = (byte)(n | 0x80);
            } else if (n < 8192) {
                if ((n2 -= 2) < 0) {
                    n2 = this.growBuffer(n2);
                }
                if (bl) {
                    n |= 0x2000;
                }
                this.myBuffer[n2] = (byte)(n >>> 7);
                this.myBuffer[n2 + 1] = (byte)(n | 0x80);
            } else if (n < 0x100000) {
                if ((n2 -= 3) < 0) {
                    n2 = this.growBuffer(n2);
                }
                if (bl) {
                    n |= 0x100000;
                }
                this.myBuffer[n2] = (byte)(n >>> 14);
                this.myBuffer[n2 + 1] = (byte)(n >>> 7 & 0x7F);
                this.myBuffer[n2 + 2] = (byte)(n | 0x80);
            } else if (n < 0x8000000) {
                if ((n2 -= 4) < 0) {
                    n2 = this.growBuffer(n2);
                }
                if (bl) {
                    n |= 0x8000000;
                }
                this.myBuffer[n2] = (byte)(n >>> 21);
                this.myBuffer[n2 + 1] = (byte)(n >>> 14 & 0x7F);
                this.myBuffer[n2 + 2] = (byte)(n >>> 7 & 0x7F);
                this.myBuffer[n2 + 3] = (byte)(n | 0x80);
            } else {
                if ((n2 -= 5) < 0) {
                    n2 = this.growBuffer(n2);
                }
                this.myBuffer[n2] = (byte)(n >>> 28 & 0x7F);
                if (bl) {
                    int n3 = n2;
                    this.myBuffer[n3] = (byte)(this.myBuffer[n3] | 0x40);
                }
                this.myBuffer[n2 + 1] = (byte)(n >>> 21 & 0x7F);
                this.myBuffer[n2 + 2] = (byte)(n >>> 14 & 0x7F);
                this.myBuffer[n2 + 3] = (byte)(n >>> 7 & 0x7F);
                this.myBuffer[n2 + 4] = (byte)(n | 0x80);
            }
            this.myOffset = n2;
        }
    }

    private void writePrefix(int n, int n2) {
        if (n2 >= 14) {
            this.writeVarUInt(n2);
            n2 = 14;
        }
        int n3 = this.myOffset;
        if (--n3 < 0) {
            n3 = this.growBuffer(n3);
        }
        this.myBuffer[n3] = (byte)(n | n2);
        this.myOffset = n3;
    }

    private void writeAnnotations(IonValue ionValue, int n) {
        SymbolToken[] symbolTokenArray = ionValue.getTypeAnnotationSymbols();
        if (symbolTokenArray.length > 0) {
            int n2 = this.myBuffer.length - this.myOffset;
            int n3 = symbolTokenArray.length;
            while (--n3 >= 0) {
                int n4 = this.findSid(symbolTokenArray[n3]);
                this.writeVarUInt(n4);
            }
            this.writeVarUInt(this.myBuffer.length - this.myOffset - n2);
            this.writePrefix(224, this.myBuffer.length - this.myOffset - n);
        }
    }

    private void writeIonNullContent() {
        int n = 15;
        this.writeByte(n);
    }

    private void writeIonBoolContent(IonBool ionBool) {
        boolean bl;
        int n = ionBool.isNullValue() ? 31 : ((bl = ionBool.booleanValue()) ? 17 : 16);
        this.writeByte(n);
    }

    private void writeIonIntContent(IonInt ionInt) {
        if (ionInt.isNullValue()) {
            this.writeByte(47);
        } else {
            int n;
            BigInteger bigInteger = ionInt.bigIntegerValue();
            int n2 = bigInteger.signum();
            int n3 = this.myBuffer.length - this.myOffset;
            if (n2 == 0) {
                this.writeByte(32);
                return;
            }
            if (n2 < 0) {
                n = 48;
                bigInteger = bigInteger.negate();
            } else {
                n = 32;
            }
            if (bigInteger.compareTo(MAX_LONG_VALUE) < 0) {
                long l = bigInteger.longValue();
                this.writeUInt(l);
            } else {
                int n4;
                byte[] byArray = bigInteger.toByteArray();
                for (n4 = 0; n4 < byArray.length && byArray[n4] == 0; ++n4) {
                }
                int n5 = byArray.length - n4;
                int n6 = this.myOffset - n5;
                if (n6 < 0) {
                    n6 = this.growBuffer(n6);
                }
                System.arraycopy(byArray, n4, this.myBuffer, n6, n5);
                this.myOffset = n6;
            }
            this.writePrefix(n, this.myBuffer.length - this.myOffset - n3);
        }
    }

    private void writeIonFloatContent(IonFloat ionFloat) {
        if (ionFloat.isNullValue()) {
            this.writeByte(79);
        } else {
            long l = Double.doubleToRawLongBits(ionFloat.doubleValue());
            int n = this.myOffset;
            if ((n -= 8) < 0) {
                n = this.growBuffer(n);
            }
            this.myBuffer[n] = (byte)(l >>> 56);
            this.myBuffer[n + 1] = (byte)(l >>> 48);
            this.myBuffer[n + 2] = (byte)(l >>> 40);
            this.myBuffer[n + 3] = (byte)(l >>> 32);
            this.myBuffer[n + 4] = (byte)(l >>> 24);
            this.myBuffer[n + 5] = (byte)(l >>> 16);
            this.myBuffer[n + 6] = (byte)(l >>> 8);
            this.myBuffer[n + 7] = (byte)l;
            this.myOffset = n;
            this.writePrefix(64, 8);
        }
    }

    private void writeIonDecimalContent(BigDecimal bigDecimal) {
        byte[] byArray;
        BigInteger bigInteger = bigDecimal.unscaledValue();
        switch (bigInteger.signum()) {
            case 0: {
                if (Decimal.isNegativeZero(bigDecimal)) {
                    byArray = negativeZeroBitArray;
                    break;
                }
                byArray = positiveZeroBitArray;
                break;
            }
            case -1: {
                byArray = bigInteger.negate().toByteArray();
                byArray[0] = (byte)(byArray[0] | 0x80);
                break;
            }
            case 1: {
                byArray = bigInteger.toByteArray();
                break;
            }
            default: {
                throw new IllegalStateException("mantissa signum out of range");
            }
        }
        this.writeBytes(byArray);
        int n = -bigDecimal.scale();
        this.writeVarInt(n);
    }

    private void writeIonDecimalContent(IonDecimal ionDecimal) {
        if (ionDecimal.isNullValue()) {
            this.writeByte(95);
        } else {
            int n = this.myBuffer.length - this.myOffset;
            this.writeIonDecimalContent(ionDecimal.decimalValue());
            this.writePrefix(80, this.myBuffer.length - this.myOffset - n);
        }
    }

    private void writeIonTimestampContent(IonTimestamp ionTimestamp) {
        if (ionTimestamp.isNullValue()) {
            this.writeByte(111);
        } else {
            Number number;
            int n = this.myBuffer.length - this.myOffset;
            Timestamp timestamp = ionTimestamp.timestampValue();
            switch (timestamp.getPrecision()) {
                case SECOND: {
                    number = timestamp.getZFractionalSecond();
                    if (number != null) {
                        assert (((BigDecimal)number).signum() >= 0 && !((BigDecimal)number).equals(BigDecimal.ZERO)) : "Bad timestamp fraction: " + number;
                        this.writeIonDecimalContent((BigDecimal)number);
                    }
                    this.writeVarUInt(timestamp.getZSecond());
                }
                case MINUTE: {
                    this.writeVarUInt(timestamp.getZMinute());
                    this.writeVarUInt(timestamp.getZHour());
                }
                case DAY: {
                    this.writeVarUInt(timestamp.getZDay());
                }
                case MONTH: {
                    this.writeVarUInt(timestamp.getZMonth());
                }
                case YEAR: {
                    this.writeVarUInt(timestamp.getZYear());
                    break;
                }
                default: {
                    throw new IllegalStateException("unrecognized Timestamp precision: " + (Object)((Object)timestamp.getPrecision()));
                }
            }
            number = timestamp.getLocalOffset();
            if (number == null) {
                this.writeByte(-64);
            } else {
                this.writeVarInt((Integer)number);
            }
            this.writePrefix(96, this.myBuffer.length - this.myOffset - n);
        }
    }

    private void writeIonSymbolContent(IonSymbol ionSymbol) {
        if (ionSymbol.isNullValue()) {
            this.writeByte(127);
        } else {
            int n = this.myBuffer.length - this.myOffset;
            SymbolToken symbolToken = ionSymbol.symbolValue();
            int n2 = this.findSid(symbolToken);
            this.writeUInt(n2);
            this.writePrefix(112, this.myBuffer.length - this.myOffset - n);
        }
    }

    private void writeIonStringContent(IonString ionString) {
        if (ionString.isNullValue()) {
            this.writeByte(-113);
        } else {
            this.writeIonStringContent(ionString.stringValue());
        }
    }

    private void writeIonStringContent(String string) {
        int n;
        int n2;
        int n3 = string.length();
        byte[] byArray = this.myBuffer;
        int n4 = this.myOffset;
        if ((n4 -= n3) < 0) {
            n4 = this.growBuffer(n4);
            byArray = this.myBuffer;
        }
        n4 += n3;
        for (n2 = n3 - 1; n2 >= 0 && (n = string.charAt(n2)) <= 127; --n2) {
            byArray[--n4] = (byte)n;
        }
        while (n2 >= 0) {
            n = string.charAt(n2);
            if (n <= 127) {
                if (--n4 < 0) {
                    n4 = this.growBuffer(n4);
                    byArray = this.myBuffer;
                }
                byArray[n4] = (byte)n;
            } else if (n <= 2047) {
                if ((n4 -= 2) < 0) {
                    n4 = this.growBuffer(n4);
                    byArray = this.myBuffer;
                }
                byArray[n4] = (byte)(0xC0 | n >> 6 & 0x1F);
                byArray[n4 + 1] = (byte)(0x80 | n & 0x3F);
            } else if (n >= 55296 && n <= 57343) {
                char c;
                if (n <= 56319) {
                    throw new IonException("invalid string, unpaired high surrogate character");
                }
                if (n2 == 0) {
                    throw new IonException("invalid string, unpaired low surrogate character");
                }
                if ((c = string.charAt(--n2)) < '\ud800' || c > '\udbff') {
                    throw new IonException("invalid string, unpaired low surrogate character");
                }
                int n5 = 65536 + ((c & 0x3FF) << 10 | n & 0x3FF);
                if ((n4 -= 4) < 0) {
                    n4 = this.growBuffer(n4);
                    byArray = this.myBuffer;
                }
                byArray[n4] = (byte)(0xF0 | n5 >> 18 & 7);
                byArray[n4 + 1] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[n4 + 2] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4 + 3] = (byte)(0x80 | n5 >> 0 & 0x3F);
            } else {
                if ((n4 -= 3) < 0) {
                    n4 = this.growBuffer(n4);
                    byArray = this.myBuffer;
                }
                byArray[n4] = (byte)(0xE0 | n >> 12 & 0xF);
                byArray[n4 + 1] = (byte)(0x80 | n >> 6 & 0x3F);
                byArray[n4 + 2] = (byte)(0x80 | n & 0x3F);
            }
            --n2;
        }
        n = this.myOffset - n4;
        this.myOffset = n4;
        this.writePrefix(128, n);
    }

    private void writeIonClobContent(IonClob ionClob) {
        if (ionClob.isNullValue()) {
            this.writeByte(-97);
        } else {
            byte[] byArray = ionClob.getBytes();
            this.writeLobContent(byArray);
            this.writePrefix(144, byArray.length);
        }
    }

    private void writeIonBlobContent(IonBlob ionBlob) {
        if (ionBlob.isNullValue()) {
            this.writeByte(-81);
        } else {
            byte[] byArray = ionBlob.getBytes();
            this.writeLobContent(byArray);
            this.writePrefix(160, byArray.length);
        }
    }

    private void writeLobContent(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.myOffset - n;
        if (n2 < 0) {
            n2 = this.growBuffer(n2);
        }
        System.arraycopy(byArray, 0, this.myBuffer, n2, n);
        this.myOffset = n2;
    }

    private void writeIonListContent(IonList ionList) {
        if (ionList.isNullValue()) {
            this.writeByte(-65);
        } else {
            this.writeIonSequenceContent(ionList);
        }
    }

    private void writeIonSexpContent(IonSexp ionSexp) {
        if (ionSexp.isNullValue()) {
            this.writeByte(-49);
        } else {
            this.writeIonSequenceContent(ionSexp);
        }
    }

    private void writeIonSequenceContent(IonSequence ionSequence) {
        int n = this.myBuffer.length - this.myOffset;
        IonValue[] ionValueArray = ionSequence.toArray();
        int n2 = ionValueArray.length;
        while (--n2 >= 0) {
            this.writeIonValue(ionValueArray[n2]);
        }
        switch (ionSequence.getType()) {
            case LIST: {
                this.writePrefix(176, this.myBuffer.length - this.myOffset - n);
                break;
            }
            case SEXP: {
                this.writePrefix(192, this.myBuffer.length - this.myOffset - n);
                break;
            }
            default: {
                throw new IonException("cannot identify instance of IonSequence");
            }
        }
    }

    private void writeIonStructContent(IonStruct ionStruct) {
        if (ionStruct.isNullValue()) {
            this.writeByte(-33);
        } else {
            int n = this.myBuffer.length - this.myOffset;
            ArrayList<IonValue> arrayList = new ArrayList<IonValue>();
            for (IonValue ionValue : ionStruct) {
                arrayList.add(ionValue);
            }
            int n2 = arrayList.size();
            while (--n2 >= 0) {
                IonValue ionValue;
                ionValue = (IonValue)arrayList.get(n2);
                SymbolToken symbolToken = ionValue.getFieldNameSymbol();
                this.writeIonValue(ionValue);
                int n3 = this.findSid(symbolToken);
                this.writeVarUInt(n3);
            }
            this.writePrefix(208, this.myBuffer.length - this.myOffset - n);
        }
    }

    private void writeIonDatagramContent(IonDatagram ionDatagram) {
        ListIterator<IonValue> listIterator = ionDatagram.listIterator(ionDatagram.size());
        while (listIterator.hasPrevious()) {
            IonValue ionValue = listIterator.previous();
            this.checkLocalSymbolTablePlacement(ionValue);
            this.writeIonValue(ionValue);
        }
    }

    private int findSid(SymbolToken symbolToken) {
        int n = symbolToken.getSid();
        String string = symbolToken.getText();
        if (n != -1) {
            assert (string == null || string.equals(this.mySymbolTable.findKnownSymbol(n)));
        } else {
            if (this.mySymbolTable.isSystemTable()) {
                this.mySymbolTable = this.myIonSystem.newLocalSymbolTable(new SymbolTable[0]);
            }
            n = this.mySymbolTable.intern(string).getSid();
        }
        return n;
    }

    private void checkLocalSymbolTablePlacement(IonValue ionValue) {
        assert (ionValue == ionValue.topLevelValue());
        SymbolTable symbolTable = ionValue.getSymbolTable();
        if (symbolTable == null) {
            throw new IllegalStateException("Binary reverse encoder isn't using LiteImpl");
        }
        if (this.mySymbolTable == null) {
            this.mySymbolTable = symbolTable;
            return;
        }
        assert (symbolTable.isLocalTable() || symbolTable.isSystemTable());
        if (symbolTable.isLocalTable()) {
            if (this.mySymbolTable.isSystemTable()) {
                this.writeBytes(PrivateIonConstants.BINARY_VERSION_MARKER_1_0);
                this.mySymbolTable = symbolTable;
            } else if (symbolTable != this.mySymbolTable) {
                this.writeLocalSymbolTable(this.mySymbolTable);
                this.mySymbolTable = symbolTable;
            }
        } else if (this.mySymbolTable.isSystemTable() && !this.mySymbolTable.getIonVersionId().equals(symbolTable.getIonVersionId())) {
            this.writeBytes(PrivateIonConstants.BINARY_VERSION_MARKER_1_0);
            this.mySymbolTable = symbolTable;
        }
    }

    private void writeLocalSymbolTable(SymbolTable symbolTable) {
        assert (symbolTable.isLocalTable());
        int n = this.myBuffer.length - this.myOffset;
        this.writeSymbolsField(symbolTable);
        this.writeImportsField(symbolTable);
        this.writePrefix(208, this.myBuffer.length - this.myOffset - n);
        byte[] byArray = new byte[]{-127, -125};
        this.writeBytes(byArray);
        this.writePrefix(224, this.myBuffer.length - this.myOffset - n);
    }

    private void writeImport(SymbolTable symbolTable) {
        assert (symbolTable.isSharedTable());
        int n = this.myBuffer.length - this.myOffset;
        int n2 = symbolTable.getMaxId();
        if (n2 == 0) {
            this.writeByte(32);
        } else {
            this.writeUInt(n2);
            this.writePrefix(32, this.myBuffer.length - this.myOffset - n);
        }
        this.writeByte(-120);
        int n3 = this.myBuffer.length - this.myOffset;
        int n4 = symbolTable.getVersion();
        this.writeUInt(n4);
        this.writePrefix(32, this.myBuffer.length - this.myOffset - n3);
        this.writeByte(-123);
        String string = symbolTable.getName();
        this.writeIonStringContent(string);
        this.writeByte(-124);
        this.writePrefix(208, this.myBuffer.length - this.myOffset - n);
    }

    private void writeImportsField(SymbolTable symbolTable) {
        SymbolTable[] symbolTableArray = symbolTable.getImportedTables();
        if (symbolTableArray.length == 0) {
            return;
        }
        int n = this.myBuffer.length - this.myOffset;
        int n2 = symbolTableArray.length;
        while (--n2 >= 0) {
            this.writeImport(symbolTableArray[n2]);
        }
        this.writePrefix(176, this.myBuffer.length - this.myOffset - n);
        this.writeByte(-122);
    }

    private void writeSymbolsField(SymbolTable symbolTable) {
        int n;
        int n2 = symbolTable.getImportedMaxId();
        if (n2 == (n = symbolTable.getMaxId())) {
            return;
        }
        int n3 = this.myBuffer.length - this.myOffset;
        for (int i = n; i > n2; --i) {
            String string = symbolTable.findKnownSymbol(i);
            if (string == null) {
                this.writeByte(-113);
                continue;
            }
            this.writeIonStringContent(string);
        }
        this.writePrefix(176, this.myBuffer.length - this.myOffset - n3);
        this.writeByte(-121);
    }
}

