/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.PrintWriter;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ReadOnlyValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateIonWriter;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContainerLite;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonDatagramLite;
import software.amazon.ion.impl.lite.IonStructLite;
import software.amazon.ion.impl.lite.IonSystemLite;
import software.amazon.ion.impl.lite.TopLevelContext;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.util.Equivalence;

abstract class IonValueLite
implements PrivateIonValue {
    private static final int TYPE_ANNOTATION_HASH_SIGNATURE = "TYPE ANNOTATION".hashCode();
    private static final IonTextWriterBuilder TO_STRING_TEXT_WRITER_BUILDER = IonTextWriterBuilder.standard().withCharsetAscii().immutable();
    protected static final int IS_LOCKED = 1;
    protected static final int IS_SYSTEM_VALUE = 2;
    protected static final int IS_NULL_VALUE = 4;
    protected static final int IS_BOOL_TRUE = 8;
    protected static final int IS_IVM = 16;
    protected static final int IS_AUTO_CREATED = 32;
    protected static final int IS_SYMBOL_PRESENT = 64;
    private static final int ELEMENT_MASK = 255;
    protected static final int ELEMENT_SHIFT = 8;
    private int _flags;
    private int _fieldId = -1;
    protected IonContext _context;
    private String _fieldName;
    private SymbolToken[] _annotations;

    protected final int _getMetadata(int n, int n2) {
        return (this._flags & n) >>> n2;
    }

    protected final void _setMetadata(int n, int n2, int n3) {
        assert (n2 <= 255);
        this._flags &= ~n2;
        this._flags |= n << n3 & n2;
    }

    protected final void _elementid(int n) {
        this._flags &= 0xFF;
        this._flags |= n << 8;
        assert (this._elementid() == n);
    }

    protected final int _elementid() {
        int n = this._flags >>> 8;
        return n;
    }

    private final boolean is_true(int n) {
        return (this._flags & n) != 0;
    }

    private final void set_flag(int n) {
        assert (n != 0);
        this._flags |= n;
    }

    private final void clear_flag(int n) {
        assert (n != 0);
        this._flags &= ~n;
    }

    protected final boolean _isLocked() {
        return this.is_true(1);
    }

    protected final boolean _isLocked(boolean bl) {
        if (bl) {
            this.set_flag(1);
        } else {
            this.clear_flag(1);
        }
        return bl;
    }

    protected final boolean _isSystemValue() {
        return this.is_true(2);
    }

    protected final boolean _isSystemValue(boolean bl) {
        if (bl) {
            this.set_flag(2);
        } else {
            this.clear_flag(2);
        }
        return bl;
    }

    protected final boolean _isNullValue() {
        return this.is_true(4);
    }

    protected final boolean _isNullValue(boolean bl) {
        if (bl) {
            this.set_flag(4);
        } else {
            this.clear_flag(4);
        }
        return bl;
    }

    protected final boolean _isBoolTrue() {
        return this.is_true(8);
    }

    protected final boolean _isBoolTrue(boolean bl) {
        if (bl) {
            this.set_flag(8);
        } else {
            this.clear_flag(8);
        }
        return bl;
    }

    protected final boolean _isIVM() {
        return this.is_true(16);
    }

    protected final boolean _isIVM(boolean bl) {
        if (bl) {
            this.set_flag(16);
        } else {
            this.clear_flag(16);
        }
        return bl;
    }

    protected final boolean _isAutoCreated() {
        return this.is_true(32);
    }

    protected final boolean _isAutoCreated(boolean bl) {
        if (bl) {
            this.set_flag(32);
        } else {
            this.clear_flag(32);
        }
        return bl;
    }

    protected final boolean _isSymbolPresent() {
        return this.is_true(64);
    }

    protected final boolean _isSymbolPresent(boolean bl) {
        if (bl) {
            this.set_flag(64);
        } else {
            this.clear_flag(64);
        }
        return bl;
    }

    IonValueLite(ContainerlessContext containerlessContext, boolean bl) {
        assert (containerlessContext != null);
        this._context = containerlessContext;
        if (bl) {
            this.set_flag(4);
        }
    }

    IonValueLite(IonValueLite ionValueLite, IonContext ionContext) {
        if (null == ionValueLite._annotations) {
            this._annotations = null;
        } else {
            int n = ionValueLite._annotations.length;
            this._annotations = new SymbolToken[n];
            for (int i = 0; i < n; ++i) {
                SymbolToken symbolToken = ionValueLite._annotations[i];
                if (symbolToken == null) continue;
                String string = symbolToken.getText();
                this._annotations[i] = string != null ? PrivateUtils.newSymbolToken(string, -1) : ionValueLite._annotations[i];
            }
        }
        this._flags = ionValueLite._flags;
        this._context = ionContext;
        this.clear_flag(1);
    }

    @Override
    public abstract void accept(ValueVisitor var1) throws Exception;

    @Override
    public void addTypeAnnotation(String string) {
        int n;
        int n2;
        this.checkForLock();
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("a user type annotation must be a non-empty string");
        }
        if (this.hasTypeAnnotation(string)) {
            return;
        }
        SymbolTokenImpl symbolTokenImpl = PrivateUtils.newSymbolToken(string, -1);
        int n3 = n2 = this._annotations == null ? 0 : this._annotations.length;
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                if (this._annotations[n] != null) continue;
                this._annotations[n] = symbolTokenImpl;
                return;
            }
        }
        n = n2 == 0 ? 1 : n2 * 2;
        SymbolToken[] symbolTokenArray = new SymbolToken[n];
        if (n2 > 0) {
            System.arraycopy(this._annotations, 0, symbolTokenArray, 0, n2);
        }
        this._annotations = symbolTokenArray;
        this._annotations[n2] = symbolTokenImpl;
    }

    @Override
    public final void clearTypeAnnotations() {
        int n;
        this.checkForLock();
        int n2 = n = this._annotations == null ? 0 : this._annotations.length;
        if (n > 0) {
            for (int i = 0; i < n && this._annotations[i] != null; ++i) {
                this._annotations[i] = null;
            }
        }
    }

    @Override
    public abstract IonValue clone();

    abstract IonValueLite clone(IonContext var1);

    @Override
    public int hashCode() {
        return this.hashCode(new LazySymbolTableProvider(this));
    }

    abstract int hashCode(PrivateIonValue.SymbolTableProvider var1);

    @Override
    public IonContainerLite getContainer() {
        return this._context.getContextContainer();
    }

    @Override
    public IonValueLite topLevelValue() {
        IonContainerLite ionContainerLite;
        assert (!(this instanceof IonDatagram));
        IonValueLite ionValueLite = this;
        while ((ionContainerLite = ionValueLite._context.getContextContainer()) != null && !(ionContainerLite instanceof IonDatagram)) {
            ionValueLite = ionContainerLite;
        }
        return ionValueLite;
    }

    @Override
    public final int getElementId() {
        return this._elementid();
    }

    @Override
    public SymbolToken getFieldNameSymbol() {
        return this.getFieldNameSymbol(new LazySymbolTableProvider(this));
    }

    @Override
    public final SymbolToken getFieldNameSymbol(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = this._fieldId;
        String string = this._fieldName;
        if (string != null) {
            SymbolToken symbolToken;
            if (n == -1 && (symbolToken = symbolTableProvider.getSymbolTable().find(string)) != null) {
                return symbolToken;
            }
        } else if (n > 0) {
            string = symbolTableProvider.getSymbolTable().findKnownSymbol(n);
        } else {
            return null;
        }
        return PrivateUtils.newSymbolToken(string, n);
    }

    void clearSymbolIDValues() {
        if (this._fieldName != null) {
            this._fieldId = -1;
        }
        if (this._annotations != null) {
            SymbolToken symbolToken;
            for (int i = 0; i < this._annotations.length && (symbolToken = this._annotations[i]) != null; ++i) {
                String string = symbolToken.getText();
                if (string == null || symbolToken.getSid() == -1) continue;
                this._annotations[i] = PrivateUtils.newSymbolToken(string, -1);
            }
        }
    }

    final void setFieldName(String string) {
        assert (this.getContainer() instanceof IonStructLite);
        assert (this._fieldId == -1 && this._fieldName == null);
        this._fieldName = string;
    }

    final void setFieldNameSymbol(SymbolToken symbolToken) {
        assert (this.getContainer() == null);
        assert (this._fieldId == -1 && this._fieldName == null);
        this._fieldName = symbolToken.getText();
        this._fieldId = symbolToken.getSid();
    }

    @Override
    public final String getFieldName() {
        if (this._fieldName != null) {
            return this._fieldName;
        }
        if (this._fieldId < 0) {
            return null;
        }
        throw new UnknownSymbolException(this._fieldId);
    }

    @Override
    public SymbolTable getSymbolTable() {
        assert (!(this instanceof IonDatagram));
        SymbolTable symbolTable = this.topLevelValue()._context.getContextSymbolTable();
        if (symbolTable != null) {
            return symbolTable;
        }
        return this._context.getSystem().getSystemSymbolTable();
    }

    @Override
    public SymbolTable getAssignedSymbolTable() {
        assert (!(this instanceof IonDatagram));
        SymbolTable symbolTable = this._context.getContextSymbolTable();
        return symbolTable;
    }

    @Override
    public IonSystemLite getSystem() {
        return this._context.getSystem();
    }

    @Override
    public IonType getType() {
        throw new UnsupportedOperationException("this type " + this.getClass().getSimpleName() + " should not be instanciated, there is not IonType associated with it");
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        return this.getTypeAnnotationSymbols(new LazySymbolTableProvider(this));
    }

    @Override
    public final SymbolToken[] getTypeAnnotationSymbols(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = 0;
        if (this._annotations != null) {
            for (int i = 0; i < this._annotations.length; ++i) {
                if (this._annotations[i] == null) continue;
                ++n;
            }
        }
        if (n == 0) {
            return SymbolToken.EMPTY_ARRAY;
        }
        SymbolToken[] symbolTokenArray = new SymbolToken[n];
        for (int i = 0; i < n; ++i) {
            SymbolToken symbolToken;
            SymbolToken symbolToken2 = this._annotations[i];
            String string = symbolToken2.getText();
            if (string != null && symbolToken2.getSid() == -1 && (symbolToken = symbolTableProvider.getSymbolTable().find(string)) != null) {
                symbolToken2 = symbolToken;
            }
            symbolTokenArray[i] = symbolToken2;
        }
        return symbolTokenArray;
    }

    @Override
    public void setTypeAnnotationSymbols(SymbolToken ... symbolTokenArray) {
        this.checkForLock();
        if (symbolTokenArray == null || symbolTokenArray.length == 0) {
            this._annotations = SymbolToken.EMPTY_ARRAY;
        } else {
            PrivateUtils.ensureNonEmptySymbols(symbolTokenArray);
            this._annotations = (SymbolToken[])symbolTokenArray.clone();
        }
    }

    @Override
    public final String[] getTypeAnnotations() {
        int n = 0;
        if (this._annotations != null) {
            int n2 = 0;
            while (n2 < this._annotations.length && this._annotations[n2] != null) {
                n = ++n2;
            }
        }
        if (n == 0) {
            return PrivateUtils.EMPTY_STRING_ARRAY;
        }
        return PrivateUtils.toStrings(this._annotations, n);
    }

    @Override
    public void setTypeAnnotations(String ... stringArray) {
        this.checkForLock();
        this._annotations = PrivateUtils.newSymbolTokens(this.getSymbolTable(), stringArray);
    }

    @Override
    public final boolean hasTypeAnnotation(String string) {
        int n;
        return string != null && string.length() > 0 && (n = this.find_type_annotation(string)) >= 0;
    }

    private final int find_type_annotation(String string) {
        assert (string != null && string.length() > 0);
        if (this._annotations != null) {
            SymbolToken symbolToken;
            for (int i = 0; i < this._annotations.length && (symbolToken = this._annotations[i]) != null; ++i) {
                if (!string.equals(symbolToken.getText())) continue;
                return i;
            }
        }
        return -1;
    }

    protected int hashTypeAnnotations(int n, PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        SymbolToken[] symbolTokenArray = this.getTypeAnnotationSymbols(symbolTableProvider);
        if (symbolTokenArray.length == 0) {
            return n;
        }
        int n2 = 127;
        int n3 = 31;
        int n4 = 8191;
        int n5 = n ^ TYPE_ANNOTATION_HASH_SIGNATURE;
        n5 = 8191 * n + symbolTokenArray.length;
        for (SymbolToken symbolToken : symbolTokenArray) {
            String string = symbolToken.getText();
            int n6 = string == null ? symbolToken.getSid() * 127 : string.hashCode() * 31;
            n6 ^= n6 << 19 ^ n6 >> 13;
            n5 = 8191 * n5 + n6;
            n5 ^= n5 << 25 ^ n5 >> 7;
        }
        return n5;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IonValue) {
            return Equivalence.ionEquals(this, (IonValue)object);
        }
        return false;
    }

    @Override
    public final boolean isNullValue() {
        return this._isNullValue();
    }

    @Override
    public final boolean isReadOnly() {
        return this._isLocked();
    }

    @Override
    public void makeReadOnly() {
        if (!this._isLocked()) {
            this.makeReadOnlyInternal();
        }
    }

    void makeReadOnlyInternal() {
        this.clearSymbolIDValues();
        this._isLocked(true);
    }

    final void checkForLock() throws ReadOnlyValueException {
        if (this._isLocked()) {
            throw new ReadOnlyValueException();
        }
    }

    @Override
    public boolean removeFromContainer() {
        this.checkForLock();
        boolean bl = false;
        IonContainerLite ionContainerLite = this._context.getContextContainer();
        if (ionContainerLite != null) {
            bl = ionContainerLite.remove(this);
        }
        return bl;
    }

    @Override
    public void removeTypeAnnotation(String string) {
        this.checkForLock();
        if (string != null && string.length() > 0) {
            SymbolToken symbolToken;
            int n;
            int n2 = this.find_type_annotation(string);
            if (n2 < 0) {
                return;
            }
            for (n = n2; n < this._annotations.length - 1 && (symbolToken = this._annotations[n + 1]) != null; ++n) {
                this._annotations[n] = symbolToken;
            }
            if (n < this._annotations.length) {
                this._annotations[n] = null;
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(TO_STRING_TEXT_WRITER_BUILDER);
    }

    @Override
    public String toString(IonTextWriterBuilder ionTextWriterBuilder) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        try {
            IonWriter ionWriter = ionTextWriterBuilder.build(stringBuilder);
            this.writeTo(ionWriter);
            ionWriter.finish();
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
        return stringBuilder.toString();
    }

    @Override
    public String toPrettyString() {
        return this.toString(IonTextWriterBuilder.pretty());
    }

    @Override
    public void writeTo(IonWriter ionWriter) {
        this.writeTo(ionWriter, new LazySymbolTableProvider(this));
    }

    final void writeChildren(IonWriter ionWriter, Iterable<IonValue> iterable, PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        boolean bl = this instanceof IonDatagram;
        for (IonValue ionValue : iterable) {
            IonValueLite ionValueLite = (IonValueLite)ionValue;
            if (bl) {
                ionValueLite.writeTo(ionWriter);
                continue;
            }
            ionValueLite.writeTo(ionWriter, symbolTableProvider);
        }
    }

    final void writeTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        Object object;
        if (ionWriter.isInStruct() && !((PrivateIonWriter)ionWriter).isFieldNameSet()) {
            object = this.getFieldNameSymbol(symbolTableProvider);
            if (object == null) {
                throw new IllegalStateException("Field name not set");
            }
            ionWriter.setFieldNameSymbol((SymbolToken)object);
        }
        object = this.getTypeAnnotationSymbols(symbolTableProvider);
        ionWriter.setTypeAnnotationSymbols((SymbolToken)object);
        try {
            this.writeBodyTo(ionWriter, symbolTableProvider);
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    abstract void writeBodyTo(IonWriter var1, PrivateIonValue.SymbolTableProvider var2) throws IOException;

    @Override
    public void setSymbolTable(SymbolTable symbolTable) {
        if (this.getContext() instanceof TopLevelContext) {
            IonDatagramLite ionDatagramLite = (IonDatagramLite)this.getContainer();
            ionDatagramLite.setSymbolTableAtIndex(this._elementid(), symbolTable);
        } else if (this.topLevelValue() == this) {
            this.setContext(ContainerlessContext.wrap(this.getContext().getSystem(), symbolTable));
        } else {
            throw new UnsupportedOperationException("can't set the symboltable of a child value");
        }
    }

    final void setContext(IonContext ionContext) {
        assert (ionContext != null);
        this.checkForLock();
        this.clearSymbolIDValues();
        this._context = ionContext;
    }

    IonContext getContext() {
        return this._context;
    }

    final void validateThisNotNull() throws NullValueException {
        if (this._isNullValue()) {
            throw new NullValueException();
        }
    }

    final void detachFromContainer() {
        this.checkForLock();
        this.clearSymbolIDValues();
        this._context = ContainerlessContext.wrap(this.getSystem());
        this._fieldName = null;
        this._fieldId = -1;
        this._elementid(0);
    }

    @Override
    public void dump(PrintWriter printWriter) {
        printWriter.println(this);
    }

    @Override
    public String validate() {
        return null;
    }

    static class LazySymbolTableProvider
    implements PrivateIonValue.SymbolTableProvider {
        SymbolTable symtab = null;
        final IonValueLite value;

        LazySymbolTableProvider(IonValueLite ionValueLite) {
            this.value = ionValueLite;
        }

        @Override
        public SymbolTable getSymbolTable() {
            if (this.symtab == null) {
                this.symtab = this.value.getSymbolTable();
            }
            return this.symtab;
        }
    }
}

