/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import software.amazon.ion.ContainedValueException;
import software.amazon.ion.IonSequence;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.PrivateCurriedValueFactory;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContainerLite;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

abstract class IonSequenceLite
extends IonContainerLite
implements IonSequence {
    protected static final IonValueLite[] EMPTY_VALUE_ARRAY = new IonValueLite[0];

    IonSequenceLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonSequenceLite(IonSequenceLite ionSequenceLite, IonContext ionContext) {
        super(ionSequenceLite, ionContext, false);
    }

    IonSequenceLite(ContainerlessContext containerlessContext, Collection<? extends IonValue> collection) throws ContainedValueException, NullPointerException, IllegalArgumentException {
        this(containerlessContext, collection == null);
        assert (this._children == null);
        if (collection != null) {
            this._children = new IonValueLite[collection.size()];
            for (IonValueLite ionValueLite : collection) {
                super.add(ionValueLite);
            }
        }
    }

    @Override
    public abstract IonSequenceLite clone();

    protected int sequenceHashCode(int n, PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n2 = 8191;
        int n3 = n;
        if (!this.isNullValue()) {
            for (IonValue ionValue : this) {
                IonValueLite ionValueLite = (IonValueLite)ionValue;
                n3 = 8191 * n3 + ionValueLite.hashCode(symbolTableProvider);
                n3 ^= n3 << 29 ^ n3 >> 3;
            }
        }
        return this.hashTypeAnnotations(n3, symbolTableProvider);
    }

    @Override
    public boolean add(IonValue ionValue) throws ContainedValueException, NullPointerException {
        return super.add(ionValue);
    }

    @Override
    public boolean addAll(Collection<? extends IonValue> collection) {
        this.checkForLock();
        if (collection == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        for (IonValue ionValue : collection) {
            bl = this.add(ionValue) || bl;
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends IonValue> collection) {
        this.checkForLock();
        if (collection == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl = false;
        for (IonValue ionValue : collection) {
            this.add(n++, ionValue);
            bl = true;
        }
        if (bl) {
            this.patch_elements_helper(n);
        }
        return bl;
    }

    @Override
    public ValueFactory add() {
        return new PrivateCurriedValueFactory(this.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonSequenceLite.this.add(ionValue);
            }
        };
    }

    @Override
    public void add(int n, IonValue ionValue) throws ContainedValueException, NullPointerException {
        this.add(n, (IonValueLite)ionValue);
    }

    @Override
    public ValueFactory add(final int n) {
        return new PrivateCurriedValueFactory(this.getSystem()){

            @Override
            protected void handle(IonValue ionValue) {
                IonSequenceLite.this.add(n, ionValue);
                IonSequenceLite.this.patch_elements_helper(n + 1);
            }
        };
    }

    @Override
    public IonValue set(int n, IonValue ionValue) {
        this.checkForLock();
        IonValueLite ionValueLite = (IonValueLite)ionValue;
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        this.validateNewChild(ionValue);
        assert (this._children != null);
        ionValueLite._context = this.getContextForIndex(ionValue, n);
        IonValueLite ionValueLite2 = this.set_child(n, ionValueLite);
        ionValueLite._elementid(n);
        ionValueLite2.detachFromContainer();
        return ionValueLite2;
    }

    @Override
    public IonValue remove(int n) {
        this.checkForLock();
        if (n < 0 || n >= this.get_child_count()) {
            throw new IndexOutOfBoundsException("" + n);
        }
        IonValueLite ionValueLite = this.get_child(n);
        assert (ionValueLite._elementid() == n);
        this.remove_child(n);
        this.patch_elements_helper(n);
        return ionValueLite;
    }

    @Override
    public boolean remove(Object object) {
        this.checkForLock();
        int n = this.lastIndexOf(object);
        if (n < 0) {
            return false;
        }
        assert (object instanceof IonValueLite);
        assert (((IonValueLite)object)._elementid() == n);
        this.remove_child(n);
        this.patch_elements_helper(n);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        this.checkForLock();
        for (Object obj : collection) {
            int n = this.lastIndexOf(obj);
            if (n < 0) continue;
            assert (obj == this.get_child(n));
            this.remove_child(n);
            this.patch_elements_helper(n);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        IonValue ionValue;
        this.checkForLock();
        if (this.get_child_count() < 1) {
            return false;
        }
        IdentityHashMap<IonValue, IonValue> identityHashMap = new IdentityHashMap<IonValue, IonValue>();
        for (Object obj : collection) {
            ionValue = (IonValue)obj;
            if (this != ionValue.getContainer()) continue;
            identityHashMap.put(ionValue, ionValue);
        }
        boolean bl = false;
        int n = this.get_child_count();
        while (n > 0) {
            if (identityHashMap.containsKey(ionValue = this.get_child(--n))) continue;
            this.remove(ionValue);
            this.patch_elements_helper(n);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof IonValue)) {
            throw new ClassCastException();
        }
        return ((IonValue)object).getContainer() == this;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        PrivateIonValue privateIonValue = (PrivateIonValue)object;
        if (this != privateIonValue.getContainer()) {
            return -1;
        }
        return privateIonValue.getElementId();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public List<IonValue> subList(int n, int n2) {
        throw new UnsupportedOperationException("issue amznlabs/ion-java#52");
    }

    @Override
    public IonValue[] toArray() {
        if (this.get_child_count() < 1) {
            return EMPTY_VALUE_ARRAY;
        }
        IonValue[] ionValueArray = new IonValue[this.get_child_count()];
        System.arraycopy(this._children, 0, ionValueArray, 0, this.get_child_count());
        return ionValueArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.get_child_count();
        if (objectArray.length < n) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, n);
        }
        if (n > 0) {
            System.arraycopy(this._children, 0, objectArray, 0, n);
        }
        if (n < objectArray.length) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    @Override
    public <T extends IonValue> T[] extract(Class<T> clazz) {
        this.checkForLock();
        if (this.isNullValue()) {
            return null;
        }
        IonValue[] ionValueArray = (IonValue[])Array.newInstance(clazz, this.size());
        this.toArray(ionValueArray);
        this.clear();
        return ionValueArray;
    }

    @Override
    void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        IonType ionType = this.getType();
        if (this.isNullValue()) {
            ionWriter.writeNull(ionType);
        } else {
            ionWriter.stepIn(ionType);
            this.writeChildren(ionWriter, this, symbolTableProvider);
            ionWriter.stepOut();
        }
    }
}

