/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonException;
import software.amazon.ion.IonLoader;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonWriter;
import software.amazon.ion.impl.PrivateIonReaderFactory;
import software.amazon.ion.impl.PrivateIonWriterFactory;
import software.amazon.ion.impl.lite.IonDatagramLite;
import software.amazon.ion.impl.lite.IonSystemLite;

final class IonLoaderLite
implements IonLoader {
    private final IonSystemLite _system;
    private final IonCatalog _catalog;

    public IonLoaderLite(IonSystemLite ionSystemLite, IonCatalog ionCatalog) {
        assert (ionSystemLite != null);
        assert (ionCatalog != null);
        this._system = ionSystemLite;
        this._catalog = ionCatalog;
    }

    @Override
    public IonSystem getSystem() {
        return this._system;
    }

    @Override
    public IonCatalog getCatalog() {
        return this._catalog;
    }

    private IonDatagramLite load_helper(IonReader ionReader) throws IOException {
        IonDatagramLite ionDatagramLite = new IonDatagramLite(this._system, this._catalog);
        IonWriter ionWriter = PrivateIonWriterFactory.makeWriter(ionDatagramLite);
        ionWriter.writeValues(ionReader);
        return ionDatagramLite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IonDatagram load(File file) throws IonException, IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IonDatagram ionDatagram;
            IonDatagram ionDatagram2 = ionDatagram = this.load(fileInputStream);
            return ionDatagram2;
        }
    }

    @Override
    public IonDatagram load(String string) throws IonException {
        try {
            IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this._system, this._catalog, string);
            IonDatagramLite ionDatagramLite = this.load_helper(ionReader);
            return ionDatagramLite;
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    @Override
    public IonDatagram load(Reader reader) throws IonException, IOException {
        try {
            IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this._system, this._catalog, reader);
            IonDatagramLite ionDatagramLite = this.load_helper(ionReader);
            return ionDatagramLite;
        }
        catch (IonException ionException) {
            IOException iOException = ionException.causeOfType(IOException.class);
            if (iOException != null) {
                throw iOException;
            }
            throw ionException;
        }
    }

    @Override
    public IonDatagram load(byte[] byArray) throws IonException {
        try {
            IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this._system, this._catalog, byArray, 0, byArray.length);
            IonDatagramLite ionDatagramLite = this.load_helper(ionReader);
            return ionDatagramLite;
        }
        catch (IOException iOException) {
            throw new IonException(iOException);
        }
    }

    @Override
    public IonDatagram load(InputStream inputStream2) throws IonException, IOException {
        try {
            IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this._system, this._catalog, inputStream2);
            IonDatagramLite ionDatagramLite = this.load_helper(ionReader);
            return ionDatagramLite;
        }
        catch (IonException ionException) {
            IOException iOException = ionException.causeOfType(IOException.class);
            if (iOException != null) {
                throw iOException;
            }
            throw ionException;
        }
    }
}

