/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.ion.IntegerSize;
import software.amazon.ion.IonInt;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonIntLite
extends IonValueLite
implements IonInt {
    private static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int HASH_SIGNATURE = IonType.INT.toString().hashCode();
    private static final int INT_SIZE_MASK = 24;
    private static final int INT_SIZE_SHIFT = 3;
    private static final IntegerSize[] SIZES = IntegerSize.values();
    private long _long_value;
    private BigInteger _big_int_value;

    IonIntLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonIntLite(IonIntLite ionIntLite, IonContext ionContext) {
        super(ionIntLite, ionContext);
        this._long_value = ionIntLite._long_value;
        this._big_int_value = ionIntLite._big_int_value;
    }

    @Override
    IonIntLite clone(IonContext ionContext) {
        return new IonIntLite(this, ionContext);
    }

    @Override
    public IonIntLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            if (this._big_int_value == null) {
                long l = this.longValue();
                n ^= (int)l;
                int n2 = (int)(l >>> 32);
                if (n2 != 0 && n2 != -1) {
                    n ^= n2;
                }
            } else {
                n = this._big_int_value.hashCode();
            }
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.INT;
    }

    @Override
    public int intValue() throws NullValueException {
        this.validateThisNotNull();
        if (this._big_int_value == null) {
            return (int)this._long_value;
        }
        return this._big_int_value.intValue();
    }

    @Override
    public long longValue() throws NullValueException {
        this.validateThisNotNull();
        if (this._big_int_value == null) {
            return this._long_value;
        }
        return this._big_int_value.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() throws NullValueException {
        if (this.isNullValue()) {
            return null;
        }
        if (this._big_int_value == null) {
            return BigInteger.valueOf(this._long_value);
        }
        return this._big_int_value;
    }

    @Override
    public void setValue(int n) {
        this.setValue((long)n);
    }

    @Override
    public void setValue(long l) {
        this.checkForLock();
        this.doSetValue(l, false);
    }

    @Override
    public void setValue(Number number) {
        this.checkForLock();
        if (number == null) {
            this.doSetValue(0L, true);
        } else if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            this.doSetValue(bigInteger);
        } else if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            this.doSetValue(bigDecimal.toBigInteger());
        } else {
            this.doSetValue(number.longValue(), false);
        }
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            ionWriter.writeNull(IonType.INT);
        } else if (this._big_int_value != null) {
            ionWriter.writeInt(this._big_int_value);
        } else {
            ionWriter.writeInt(this._long_value);
        }
    }

    private void doSetValue(long l, boolean bl) {
        this._long_value = l;
        this._big_int_value = null;
        this._isNullValue(bl);
        if (!bl) {
            if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                this.setSize(IntegerSize.LONG);
            } else {
                this.setSize(IntegerSize.INT);
            }
        }
    }

    private void doSetValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(LONG_MIN_VALUE) < 0 || bigInteger.compareTo(LONG_MAX_VALUE) > 0) {
            this.setSize(IntegerSize.BIG_INTEGER);
            this._long_value = 0L;
            this._big_int_value = bigInteger;
            this._isNullValue(false);
        } else {
            this.doSetValue(bigInteger.longValue(), false);
        }
    }

    private void setSize(IntegerSize integerSize) {
        this._setMetadata(integerSize.ordinal(), 24, 3);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }

    @Override
    public IntegerSize getIntegerSize() {
        if (this.isNullValue()) {
            return null;
        }
        return SIZES[this._getMetadata(24, 3)];
    }
}

