/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.math.BigDecimal;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonFloat;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonFloatLite
extends IonValueLite
implements IonFloat {
    private static final int HASH_SIGNATURE = IonType.FLOAT.toString().hashCode();
    private Double _float_value;

    IonFloatLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonFloatLite(IonFloatLite ionFloatLite, IonContext ionContext) {
        super(ionFloatLite, ionContext);
        this._float_value = ionFloatLite._float_value;
    }

    @Override
    IonFloatLite clone(IonContext ionContext) {
        return new IonFloatLite(this, ionContext);
    }

    @Override
    public IonFloatLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            long l = Double.doubleToLongBits(this.doubleValue());
            n ^= (int)(l >>> 32 ^ l);
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.FLOAT;
    }

    @Override
    public float floatValue() throws NullValueException {
        this.validateThisNotNull();
        return this._float_value.floatValue();
    }

    @Override
    public double doubleValue() throws NullValueException {
        this.validateThisNotNull();
        return this._float_value;
    }

    @Override
    public BigDecimal bigDecimalValue() throws NullValueException {
        if (this.isNullValue()) {
            return null;
        }
        return Decimal.valueOf(this._float_value);
    }

    @Override
    public void setValue(float f) {
        this.setValue(new Double(f));
    }

    @Override
    public void setValue(double d) {
        this.setValue(new Double(d));
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.checkForLock();
        if (bigDecimal == null) {
            this._float_value = null;
            this._isNullValue(true);
        } else {
            this.setValue(bigDecimal.doubleValue());
        }
    }

    public void setValue(Double d) {
        this.checkForLock();
        this._float_value = d;
        this._isNullValue(d == null);
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            ionWriter.writeNull(IonType.FLOAT);
        } else {
            ionWriter.writeFloat(this._float_value);
        }
    }

    @Override
    public boolean isNumericValue() {
        return !this.isNullValue() && !this._float_value.isNaN() && !this._float_value.isInfinite();
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

