/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.math.BigDecimal;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonDecimal;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.NullValueException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonDecimalLite
extends IonValueLite
implements IonDecimal {
    private static final int HASH_SIGNATURE = IonType.DECIMAL.toString().hashCode();
    private static final int NEGATIVE_ZERO_HASH_SIGNATURE = "NEGATIVE ZERO".hashCode();
    private BigDecimal _decimal_value;

    public static boolean isNegativeZero(float f) {
        if (f != 0.0f) {
            return false;
        }
        return (Float.floatToRawIntBits(f) & Integer.MIN_VALUE) != 0;
    }

    public static boolean isNegativeZero(double d) {
        if (d != 0.0) {
            return false;
        }
        return (Double.doubleToLongBits(d) & Long.MIN_VALUE) != 0L;
    }

    IonDecimalLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonDecimalLite(IonDecimalLite ionDecimalLite, IonContext ionContext) {
        super(ionDecimalLite, ionContext);
        this._decimal_value = ionDecimalLite._decimal_value;
    }

    @Override
    IonDecimalLite clone(IonContext ionContext) {
        return new IonDecimalLite(this, ionContext);
    }

    @Override
    public IonDecimalLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            Decimal decimal = this.decimalValue();
            n ^= decimal.hashCode();
            if (decimal.isNegativeZero()) {
                n ^= NEGATIVE_ZERO_HASH_SIGNATURE;
            }
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.DECIMAL;
    }

    @Override
    public float floatValue() throws NullValueException {
        if (this._isNullValue()) {
            throw new NullValueException();
        }
        float f = this._decimal_value.floatValue();
        return f;
    }

    @Override
    public double doubleValue() throws NullValueException {
        if (this._isNullValue()) {
            throw new NullValueException();
        }
        double d = this._decimal_value.doubleValue();
        return d;
    }

    @Override
    public BigDecimal bigDecimalValue() throws NullValueException {
        return Decimal.bigDecimalValue(this._decimal_value);
    }

    @Override
    public Decimal decimalValue() throws NullValueException {
        return Decimal.valueOf(this._decimal_value);
    }

    @Override
    public void setValue(long l) {
        this.setValue(Decimal.valueOf(l));
    }

    @Override
    public void setValue(float f) {
        this.setValue(Decimal.valueOf(f));
    }

    @Override
    public void setValue(double d) {
        this.setValue(Decimal.valueOf(d));
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.checkForLock();
        this._decimal_value = bigDecimal;
        this._isNullValue(bigDecimal == null);
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionWriter.writeDecimal(this._decimal_value);
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

