/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import software.amazon.ion.IonClob;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonLobLite;

final class IonClobLite
extends IonLobLite
implements IonClob {
    private static final int HASH_SIGNATURE = IonType.CLOB.toString().hashCode();

    IonClobLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonClobLite(IonClobLite ionClobLite, IonContext ionContext) {
        super(ionClobLite, ionContext);
    }

    @Override
    IonClobLite clone(IonContext ionContext) {
        return new IonClobLite(this, ionContext);
    }

    @Override
    public IonClobLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        return this.lobHashCode(HASH_SIGNATURE, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.CLOB;
    }

    @Override
    public Reader newReader(Charset charset) {
        InputStream inputStream2 = this.newInputStream();
        if (inputStream2 == null) {
            return null;
        }
        return new InputStreamReader(inputStream2, charset);
    }

    @Override
    public String stringValue(Charset charset) {
        byte[] byArray = this.getBytes();
        if (byArray == null) {
            return null;
        }
        return PrivateUtils.decode(byArray, charset);
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionWriter.writeClob(this.getBytesNoCopy());
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

