/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.ion.IonBlob;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonLobLite;

final class IonBlobLite
extends IonLobLite
implements IonBlob {
    private static final int HASH_SIGNATURE = IonType.BLOB.toString().hashCode();

    IonBlobLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonBlobLite(IonBlobLite ionBlobLite, IonContext ionContext) {
        super(ionBlobLite, ionContext);
    }

    @Override
    IonBlobLite clone(IonContext ionContext) {
        return new IonBlobLite(this, ionContext);
    }

    @Override
    public IonBlobLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        return this.lobHashCode(HASH_SIGNATURE, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.BLOB;
    }

    @Override
    public void printBase64(Appendable appendable) throws IOException {
        this.validateThisNotNull();
        try (InputStream inputStream2 = this.newInputStream();){
            PrivateUtils.writeAsBase64(inputStream2, appendable);
        }
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionWriter.writeBlob(this.getBytesNoCopy());
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

