/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SubstituteSymbolTableException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.impl.bin.AbstractIonWriter;
import software.amazon.ion.impl.bin.BlockAllocatorProvider;
import software.amazon.ion.impl.bin.BlockAllocatorProviders;
import software.amazon.ion.impl.bin.IonManagedBinaryWriter;
import software.amazon.ion.impl.bin.IonRawBinaryWriter;
import software.amazon.ion.impl.bin.PooledBlockAllocatorProvider;
import software.amazon.ion.system.SimpleCatalog;

@Deprecated
public final class PrivateIonManagedBinaryWriterBuilder {
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    final BlockAllocatorProvider provider;
    volatile int symbolsBlockSize;
    volatile int userBlockSize;
    volatile IonRawBinaryWriter.PreallocationMode preallocationMode;
    volatile IonManagedBinaryWriter.ImportedSymbolContext imports;
    volatile IonCatalog catalog;
    volatile AbstractIonWriter.WriteValueOptimization optimization;
    volatile SymbolTable initialSymbolTable;
    volatile boolean isFloatBinary32Enabled;

    private PrivateIonManagedBinaryWriterBuilder(BlockAllocatorProvider blockAllocatorProvider) {
        this.provider = blockAllocatorProvider;
        this.symbolsBlockSize = 32768;
        this.userBlockSize = 32768;
        this.imports = IonManagedBinaryWriter.ONLY_SYSTEM_IMPORTS;
        this.preallocationMode = IonRawBinaryWriter.PreallocationMode.PREALLOCATE_2;
        this.catalog = new SimpleCatalog();
        this.optimization = AbstractIonWriter.WriteValueOptimization.NONE;
        this.isFloatBinary32Enabled = false;
    }

    private PrivateIonManagedBinaryWriterBuilder(PrivateIonManagedBinaryWriterBuilder privateIonManagedBinaryWriterBuilder) {
        this.provider = privateIonManagedBinaryWriterBuilder.provider;
        this.symbolsBlockSize = privateIonManagedBinaryWriterBuilder.symbolsBlockSize;
        this.userBlockSize = privateIonManagedBinaryWriterBuilder.userBlockSize;
        this.preallocationMode = privateIonManagedBinaryWriterBuilder.preallocationMode;
        this.imports = privateIonManagedBinaryWriterBuilder.imports;
        this.catalog = privateIonManagedBinaryWriterBuilder.catalog;
        this.optimization = privateIonManagedBinaryWriterBuilder.optimization;
        this.initialSymbolTable = privateIonManagedBinaryWriterBuilder.initialSymbolTable;
        this.isFloatBinary32Enabled = privateIonManagedBinaryWriterBuilder.isFloatBinary32Enabled;
    }

    public PrivateIonManagedBinaryWriterBuilder copy() {
        return new PrivateIonManagedBinaryWriterBuilder(this);
    }

    public PrivateIonManagedBinaryWriterBuilder withSymbolsBlockSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Block size cannot be less than 1: " + n);
        }
        this.symbolsBlockSize = n;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withUserBlockSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Block size cannot be less than 1: " + n);
        }
        this.userBlockSize = n;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withImports(SymbolTable ... symbolTableArray) {
        if (symbolTableArray != null) {
            return this.withImports(Arrays.asList(symbolTableArray));
        }
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withImports(List<SymbolTable> list) {
        return this.withImports(IonManagedBinaryWriter.ImportedSymbolResolverMode.DELEGATE, list);
    }

    public PrivateIonManagedBinaryWriterBuilder withFlatImports(SymbolTable ... symbolTableArray) {
        if (symbolTableArray != null) {
            return this.withFlatImports(Arrays.asList(symbolTableArray));
        }
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withFlatImports(List<SymbolTable> list) {
        return this.withImports(IonManagedBinaryWriter.ImportedSymbolResolverMode.FLAT, list);
    }

    PrivateIonManagedBinaryWriterBuilder withImports(IonManagedBinaryWriter.ImportedSymbolResolverMode importedSymbolResolverMode, List<SymbolTable> list) {
        this.imports = new IonManagedBinaryWriter.ImportedSymbolContext(importedSymbolResolverMode, list);
        return this;
    }

    PrivateIonManagedBinaryWriterBuilder withPreallocationMode(IonRawBinaryWriter.PreallocationMode preallocationMode) {
        this.preallocationMode = preallocationMode;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withPaddedLengthPreallocation(int n) {
        this.preallocationMode = IonRawBinaryWriter.PreallocationMode.withPadSize(n);
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withCatalog(IonCatalog ionCatalog) {
        this.catalog = ionCatalog;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withStreamCopyOptimization(boolean bl) {
        this.optimization = bl ? AbstractIonWriter.WriteValueOptimization.COPY_OPTIMIZED : AbstractIonWriter.WriteValueOptimization.NONE;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withFloatBinary32Enabled() {
        this.isFloatBinary32Enabled = true;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withFloatBinary32Disabled() {
        this.isFloatBinary32Enabled = false;
        return this;
    }

    public PrivateIonManagedBinaryWriterBuilder withInitialSymbolTable(SymbolTable symbolTable) {
        if (symbolTable != null) {
            if (!symbolTable.isLocalTable() && !symbolTable.isSystemTable()) {
                throw new IllegalArgumentException("Initial symbol table must be local or system");
            }
            if (symbolTable.isSystemTable()) {
                if (symbolTable.getMaxId() != 9) {
                    throw new IllegalArgumentException("Unsupported system symbol table");
                }
                symbolTable = null;
            } else {
                for (SymbolTable symbolTable2 : symbolTable.getImportedTables()) {
                    if (!symbolTable2.isSubstitute()) continue;
                    throw new SubstituteSymbolTableException("Cannot use initial symbol table with imported substitutes");
                }
            }
        }
        this.initialSymbolTable = symbolTable;
        return this;
    }

    public IonWriter newWriter(OutputStream outputStream2) throws IOException {
        return new IonManagedBinaryWriter(this, outputStream2);
    }

    public static PrivateIonManagedBinaryWriterBuilder create(AllocatorMode allocatorMode) {
        return new PrivateIonManagedBinaryWriterBuilder(allocatorMode.createAllocatorProvider());
    }

    public static enum AllocatorMode {
        POOLED{

            @Override
            BlockAllocatorProvider createAllocatorProvider() {
                return new PooledBlockAllocatorProvider();
            }
        }
        ,
        BASIC{

            @Override
            BlockAllocatorProvider createAllocatorProvider() {
                return BlockAllocatorProviders.basicProvider();
            }
        };


        abstract BlockAllocatorProvider createAllocatorProvider();
    }
}

