/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import software.amazon.ion.impl.bin.Block;
import software.amazon.ion.impl.bin.BlockAllocator;
import software.amazon.ion.impl.bin.BlockAllocatorProvider;

final class PooledBlockAllocatorProvider
extends BlockAllocatorProvider {
    private final ConcurrentMap<Integer, BlockAllocator> allocators = new ConcurrentHashMap<Integer, BlockAllocator>();

    @Override
    public BlockAllocator vendAllocator(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid block size: " + n);
        }
        BlockAllocator blockAllocator = (BlockAllocator)this.allocators.get(n);
        if (blockAllocator == null) {
            blockAllocator = new PooledBlockAllocator(n);
            BlockAllocator blockAllocator2 = this.allocators.putIfAbsent(n, blockAllocator);
            if (blockAllocator2 != null) {
                blockAllocator = blockAllocator2;
            }
        }
        return blockAllocator;
    }

    private final class PooledBlockAllocator
    extends BlockAllocator {
        private final int blockSize;
        private final ConcurrentLinkedQueue<Block> freeBlocks;

        public PooledBlockAllocator(int n) {
            this.blockSize = n;
            this.freeBlocks = new ConcurrentLinkedQueue();
        }

        @Override
        public Block allocateBlock() {
            Block block = this.freeBlocks.poll();
            if (block == null) {
                block = new Block(new byte[this.blockSize]){

                    @Override
                    public void close() {
                        this.reset();
                        PooledBlockAllocator.this.freeBlocks.add(this);
                    }
                };
            }
            return block;
        }

        @Override
        public int getBlockSize() {
            return this.blockSize;
        }

        @Override
        public void close() {
        }
    }
}

