/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ReadOnlyValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.IonReaderTreeSystem;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.SymbolTableReader;
import software.amazon.ion.impl.SymbolTokenImpl;

final class SharedSymbolTable
implements SymbolTable {
    private static final String[] SYSTEM_SYMBOLS = new String[]{"$ion", "$ion_1_0", "$ion_symbol_table", "name", "version", "imports", "symbols", "max_id", "$ion_shared_symbol_table"};
    private static final SymbolTable ION_1_0_SYSTEM_SYMTAB;
    private final String myName;
    private final int myVersion;
    private final String[] mySymbolNames;
    private final Map<String, Integer> mySymbolsMap;

    private SharedSymbolTable(String string, int n, List<String> list, Map<String, Integer> map) {
        this.myName = string;
        this.myVersion = n;
        this.mySymbolsMap = map;
        this.mySymbolNames = list.toArray(new String[list.size()]);
    }

    private SharedSymbolTable(String string, int n, String[] stringArray, Map<String, Integer> map) {
        this.myName = string;
        this.myVersion = n;
        this.mySymbolsMap = map;
        this.mySymbolNames = stringArray;
    }

    static SymbolTable newSharedSymbolTable(String string, int n, SymbolTable symbolTable, Iterator<String> iterator2) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("name must be non-empty");
        }
        if (n < 1) {
            throw new IllegalArgumentException("version must be at least 1");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        assert (n == (symbolTable == null ? 1 : symbolTable.getVersion() + 1));
        SharedSymbolTable.prepSymbolsListAndMap(symbolTable, iterator2, arrayList, hashMap);
        return new SharedSymbolTable(string, n, arrayList, hashMap);
    }

    static SymbolTable newSharedSymbolTable(IonStruct ionStruct) {
        IonReaderTreeSystem ionReaderTreeSystem = new IonReaderTreeSystem(ionStruct);
        return SharedSymbolTable.newSharedSymbolTable(ionReaderTreeSystem, false);
    }

    static SymbolTable newSharedSymbolTable(IonReader ionReader, boolean bl) {
        Object object;
        Object object2;
        if (!bl && (object2 = ionReader.next()) != IonType.STRUCT) {
            throw new IonException("invalid symbol table image passed into reader, " + (Object)object2 + " encountered when a " + "struct was expected");
        }
        object2 = null;
        int n = -1;
        ArrayList<String> arrayList = new ArrayList<String>();
        ionReader.stepIn();
        IonType ionType = null;
        while ((ionType = ionReader.next()) != null) {
            Object object3;
            if (ionReader.isNullValue()) continue;
            object = ionReader.getFieldNameSymbol();
            int n2 = object.getSid();
            if (n2 == -1) {
                object3 = ionReader.getFieldName();
                n2 = PrivateUtils.getSidForSymbolTableField(object3);
            }
            switch (n2) {
                case 5: {
                    if (ionType != IonType.INT) break;
                    n = ionReader.intValue();
                    break;
                }
                case 4: {
                    if (ionType != IonType.STRING) break;
                    object2 = ionReader.stringValue();
                    break;
                }
                case 7: {
                    if (ionType != IonType.LIST) break;
                    ionReader.stepIn();
                    while ((object3 = ionReader.next()) != null) {
                        String string = null;
                        if (object3 == IonType.STRING && !ionReader.isNullValue() && (string = ionReader.stringValue()).length() == 0) {
                            string = null;
                        }
                        arrayList.add(string);
                    }
                    ionReader.stepOut();
                    break;
                }
            }
        }
        ionReader.stepOut();
        if (object2 == null || ((String)object2).length() == 0) {
            object = "shared symbol table is malformed: field 'name' must be a non-empty string.";
            throw new IonException((String)object);
        }
        n = n < 1 ? 1 : n;
        object = null;
        if (!arrayList.isEmpty()) {
            object = new HashMap();
            SharedSymbolTable.transferNonExistingSymbols(arrayList, object);
        } else {
            object = Collections.emptyMap();
        }
        return new SharedSymbolTable((String)object2, n, (List<String>)arrayList, (Map<String, Integer>)object);
    }

    static SymbolTable getSystemSymbolTable(int n) {
        if (n != 1) {
            throw new IllegalArgumentException("only Ion 1.0 system symbols are supported");
        }
        return ION_1_0_SYSTEM_SYMTAB;
    }

    private static void putToMapIfNotThere(Map<String, Integer> map, String string, int n) {
        Integer n2 = map.put(string, n);
        if (n2 != null) {
            assert (n2 < n);
            map.put(string, n2);
        }
    }

    private static void prepSymbolsListAndMap(SymbolTable symbolTable, Iterator<String> iterator2, List<String> list, Map<String, Integer> map) {
        Object object;
        int n = 1;
        if (symbolTable != null) {
            object = symbolTable.iterateDeclaredSymbolNames();
            while (object.hasNext()) {
                String string = object.next();
                if (string != null) {
                    assert (string.length() > 0);
                    SharedSymbolTable.putToMapIfNotThere(map, string, n);
                }
                list.add(string);
                ++n;
            }
        }
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (map.get(object) != null) continue;
            SharedSymbolTable.putToMapIfNotThere(map, (String)object, n);
            list.add((String)object);
            ++n;
        }
    }

    private static void transferNonExistingSymbols(List<String> list, Map<String, Integer> map) {
        int n = 1;
        for (String string : list) {
            assert (string == null || string.length() > 0);
            if (string != null) {
                SharedSymbolTable.putToMapIfNotThere(map, string, n);
            }
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public int getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isLocalTable() {
        return false;
    }

    @Override
    public boolean isSharedTable() {
        return true;
    }

    @Override
    public boolean isSubstitute() {
        return false;
    }

    @Override
    public boolean isSystemTable() {
        return "$ion".equals(this.myName);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void makeReadOnly() {
    }

    @Override
    public SymbolTable getSystemSymbolTable() {
        if (this.isSystemTable()) {
            return this;
        }
        return null;
    }

    @Override
    public String getIonVersionId() {
        if (this.isSystemTable()) {
            int n = this.getVersion();
            if (n != 1) {
                throw new IonException("unrecognized system version encountered: " + n);
            }
            return "$ion_1_0";
        }
        return null;
    }

    @Override
    public SymbolTable[] getImportedTables() {
        return null;
    }

    @Override
    public int getImportedMaxId() {
        return 0;
    }

    @Override
    public int getMaxId() {
        return this.mySymbolNames.length;
    }

    @Override
    public SymbolToken intern(String string) {
        SymbolToken symbolToken = this.find(string);
        if (symbolToken == null) {
            throw new ReadOnlyValueException(SymbolTable.class);
        }
        return symbolToken;
    }

    @Override
    public SymbolToken find(String string) {
        if (string.length() < 1) {
            throw new EmptySymbolException();
        }
        Integer n = this.mySymbolsMap.get(string);
        if (n != null) {
            assert (n != -1);
            int n2 = n - 1;
            String string2 = this.mySymbolNames[n2];
            assert (string2 != null);
            return new SymbolTokenImpl(string2, n);
        }
        return null;
    }

    @Override
    public int findSymbol(String string) {
        if (string.length() < 1) {
            throw new EmptySymbolException();
        }
        Integer n = this.mySymbolsMap.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public String findKnownSymbol(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("symbol IDs must be greater than 0");
        }
        int n2 = n - 1;
        if (n2 < this.mySymbolNames.length) {
            return this.mySymbolNames[n2];
        }
        return null;
    }

    @Override
    public Iterator<String> iterateDeclaredSymbolNames() {
        return Collections.unmodifiableList(Arrays.asList(this.mySymbolNames)).iterator();
    }

    @Override
    public void writeTo(IonWriter ionWriter) throws IOException {
        SymbolTableReader symbolTableReader = new SymbolTableReader(this);
        ionWriter.writeValues(symbolTableReader);
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < SYSTEM_SYMBOLS.length; ++i) {
            hashMap.put(SYSTEM_SYMBOLS[i], i + 1);
        }
        ION_1_0_SYSTEM_SYMTAB = new SharedSymbolTable("$ion", 1, SYSTEM_SYMBOLS, hashMap);
    }
}

